/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.actions.FileURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FileUriKeySelector
implements KeySelector<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(FileUriKeySelector.class);
    static final String INVALID_URI = "__INVALID_URI__";
    private final Map<String, String> equalSchemes;
    private final Map<String, String> equalAuthorities;

    public FileUriKeySelector(Map<String, String> equalSchemes, Map<String, String> equalAuthorities) {
        this.equalSchemes = equalSchemes;
        this.equalAuthorities = equalAuthorities;
    }

    public String getKey(String value) throws Exception {
        try {
            FileURI fileUri = new FileURI(new Path(value).toUri(), this.equalSchemes, this.equalAuthorities);
            return fileUri.getPath();
        }
        catch (Exception e) {
            LOG.warn("Uri convert to FileURI error! Uri is {}.", (Object)value, (Object)e);
            return INVALID_URI;
        }
    }
}

