/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.maintenance.api.DeleteOrphanFiles;
import org.apache.iceberg.flink.maintenance.api.Trigger;
import org.apache.iceberg.flink.maintenance.operator.TableMaintenanceMetrics;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ListMetadataFiles
extends ProcessFunction<Trigger, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ListMetadataFiles.class);
    private final String taskName;
    private final int taskIndex;
    private transient Counter errorCounter;
    private final TableLoader tableLoader;
    private transient Table table;

    public ListMetadataFiles(String taskName, int taskIndex, TableLoader tableLoader) {
        Preconditions.checkNotNull((Object)taskName, (Object)"Task name should no be null");
        Preconditions.checkNotNull((Object)tableLoader, (Object)"TableLoader should no be null");
        this.tableLoader = tableLoader;
        this.taskName = taskName;
        this.taskIndex = taskIndex;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.tableLoader.open();
        this.table = this.tableLoader.loadTable();
        this.errorCounter = TableMaintenanceMetrics.groupFor(this.getRuntimeContext(), this.table.name(), this.taskName, this.taskIndex).counter("error");
    }

    public void processElement(Trigger trigger, ProcessFunction.Context ctx, Collector<String> collector) throws Exception {
        try {
            this.table.snapshots().forEach(snapshot -> {
                collector.collect((Object)snapshot.manifestListLocation());
                ReachableFileUtil.metadataFileLocations((Table)this.table, (boolean)false).forEach(arg_0 -> ((Collector)collector).collect(arg_0));
                ReachableFileUtil.statisticsFilesLocations((Table)this.table).forEach(arg_0 -> ((Collector)collector).collect(arg_0));
                collector.collect((Object)ReachableFileUtil.versionHintLocation((Table)this.table));
                snapshot.allManifests(this.table.io()).stream().map(ManifestFile::path).forEach(arg_0 -> ((Collector)collector).collect(arg_0));
            });
        }
        catch (Exception e) {
            LOG.error("Exception listing metadata files for {} at {}", new Object[]{this.table, ctx.timestamp(), e});
            ctx.output(DeleteOrphanFiles.ERROR_STREAM, (Object)e);
            this.errorCounter.inc();
        }
    }
}

