/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceEnumerator;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceReader;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

@Internal
public abstract class SingleThreadedIteratorSource<T>
implements Source<T, GlobalSplit<T>, Collection<GlobalSplit<T>>>,
ResultTypeQueryable<T> {
    private static final String PARALLELISM_ERROR = "Parallelism should be set to 1";

    abstract Iterator<T> createIterator();

    abstract SimpleVersionedSerializer<Iterator<T>> iteratorSerializer();

    public SplitEnumerator<GlobalSplit<T>, Collection<GlobalSplit<T>>> createEnumerator(SplitEnumeratorContext<GlobalSplit<T>> enumContext) {
        Preconditions.checkArgument((enumContext.currentParallelism() == 1 ? 1 : 0) != 0, (Object)PARALLELISM_ERROR);
        return new IteratorSourceEnumerator(enumContext, (Collection)ImmutableList.of(new GlobalSplit<T>(this.createIterator())));
    }

    public SplitEnumerator<GlobalSplit<T>, Collection<GlobalSplit<T>>> restoreEnumerator(SplitEnumeratorContext<GlobalSplit<T>> enumContext, Collection<GlobalSplit<T>> checkpoint) {
        Preconditions.checkArgument((enumContext.currentParallelism() == 1 ? 1 : 0) != 0, (Object)PARALLELISM_ERROR);
        return new IteratorSourceEnumerator(enumContext, checkpoint);
    }

    public SimpleVersionedSerializer<GlobalSplit<T>> getSplitSerializer() {
        return new SplitSerializer<T>(this.iteratorSerializer());
    }

    public SimpleVersionedSerializer<Collection<GlobalSplit<T>>> getEnumeratorCheckpointSerializer() {
        return new EnumeratorSerializer<T>(this.iteratorSerializer());
    }

    public SourceReader<T, GlobalSplit<T>> createReader(SourceReaderContext readerContext) throws Exception {
        Preconditions.checkArgument((readerContext.getIndexOfSubtask() == 0 ? 1 : 0) != 0, (Object)PARALLELISM_ERROR);
        return new IteratorSourceReader(readerContext);
    }

    static class GlobalSplit<T>
    implements IteratorSourceSplit<T, Iterator<T>> {
        private final Iterator<T> iterator;

        GlobalSplit(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public String splitId() {
            return "1";
        }

        public Iterator<T> getIterator() {
            return this.iterator;
        }

        public IteratorSourceSplit<T, Iterator<T>> getUpdatedSplitForIterator(Iterator<T> newIterator) {
            return new GlobalSplit<T>(newIterator);
        }

        public String toString() {
            return String.format("GlobalSplit (%s)", this.iterator);
        }
    }

    private static final class SplitSerializer<T>
    implements SimpleVersionedSerializer<GlobalSplit<T>> {
        private final SimpleVersionedSerializer<Iterator<T>> iteratorSerializer;
        private static final int CURRENT_VERSION = 1;

        SplitSerializer(SimpleVersionedSerializer<Iterator<T>> iteratorSerializer) {
            this.iteratorSerializer = iteratorSerializer;
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(GlobalSplit<T> split) throws IOException {
            return this.iteratorSerializer.serialize(split.iterator);
        }

        public GlobalSplit<T> deserialize(int version, byte[] serialized) throws IOException {
            return new GlobalSplit((Iterator)this.iteratorSerializer.deserialize(version, serialized));
        }
    }

    private static final class EnumeratorSerializer<T>
    implements SimpleVersionedSerializer<Collection<GlobalSplit<T>>> {
        private static final int CURRENT_VERSION = 1;
        private final SimpleVersionedSerializer<Iterator<T>> iteratorSerializer;

        EnumeratorSerializer(SimpleVersionedSerializer<Iterator<T>> iteratorSerializer) {
            this.iteratorSerializer = iteratorSerializer;
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(Collection<GlobalSplit<T>> checkpoint) throws IOException {
            Preconditions.checkArgument((checkpoint.size() < 2 ? 1 : 0) != 0, (Object)SingleThreadedIteratorSource.PARALLELISM_ERROR);
            if (checkpoint.isEmpty()) {
                return new byte[]{0};
            }
            byte[] iterator = this.iteratorSerializer.serialize(checkpoint.iterator().next().getIterator());
            byte[] result = new byte[iterator.length + 1];
            result[0] = 1;
            System.arraycopy(iterator, 0, result, 1, iterator.length);
            return result;
        }

        public Collection<GlobalSplit<T>> deserialize(int version, byte[] serialized) throws IOException {
            if (serialized[0] == 0) {
                return Lists.newArrayList();
            }
            byte[] iterator = new byte[serialized.length - 1];
            System.arraycopy(serialized, 1, iterator, 0, serialized.length - 1);
            return Lists.newArrayList((Object[])new GlobalSplit[]{new GlobalSplit((Iterator)this.iteratorSerializer.deserialize(version, iterator))});
        }
    }
}

