/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SkipOnError
extends AbstractStreamOperator<String>
implements TwoInputStreamOperator<String, Exception, String> {
    private static final Logger LOG = LoggerFactory.getLogger(SkipOnError.class);
    private transient ListState<String> filesToDelete;
    private transient ListState<Boolean> hasError;
    private boolean hasErrorFlag = false;

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.filesToDelete = context.getOperatorStateStore().getListState(new ListStateDescriptor("blockOnErrorFiles", String.class));
        this.hasError = context.getOperatorStateStore().getListState(new ListStateDescriptor("blockOnErrorHasError", Types.BOOLEAN));
        if (!Iterables.isEmpty((Iterable)((Iterable)this.hasError.get()))) {
            this.hasErrorFlag = true;
        }
    }

    public void processElement1(StreamRecord<String> element) throws Exception {
        if (!this.hasErrorFlag) {
            this.filesToDelete.add((Object)((String)element.getValue()));
        }
    }

    public void processElement2(StreamRecord<Exception> element) throws Exception {
        this.hasError.add((Object)true);
        this.hasErrorFlag = true;
        this.filesToDelete.clear();
    }

    public void processWatermark(Watermark mark) throws Exception {
        try {
            if (!this.hasErrorFlag) {
                ((Iterable)this.filesToDelete.get()).forEach(file -> this.output.collect((Object)new StreamRecord(file)));
            } else {
                LOG.info("Omitting result on failure at {}", (Object)mark.getTimestamp());
            }
        }
        finally {
            this.filesToDelete.clear();
            this.hasError.clear();
            this.hasErrorFlag = false;
        }
        super.processWatermark(mark);
    }
}

