/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;
import org.apache.iceberg.flink.maintenance.api.TaskResult;
import org.apache.iceberg.flink.maintenance.api.Trigger;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TaskResultAggregator
extends AbstractStreamOperator<TaskResult>
implements TwoInputStreamOperator<Trigger, Exception, TaskResult> {
    public static final OutputTag<Exception> ERROR_STREAM = new OutputTag("error-stream", TypeInformation.of(Exception.class));
    private static final Logger LOG = LoggerFactory.getLogger(TaskResultAggregator.class);
    private final String tableName;
    private final String taskName;
    private final int taskIndex;
    private final List<Exception> exceptions;
    private transient long startTime;

    public TaskResultAggregator(String tableName, String taskName, int taskIndex) {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name should no be null");
        Preconditions.checkNotNull((Object)taskName, (Object)"Task name should no be null");
        this.tableName = tableName;
        this.taskName = taskName;
        this.taskIndex = taskIndex;
        this.exceptions = Lists.newArrayList();
    }

    public void processElement1(StreamRecord<Trigger> streamRecord) {
        this.startTime = ((Trigger)streamRecord.getValue()).timestamp();
    }

    public void processElement2(StreamRecord<Exception> streamRecord) {
        Preconditions.checkNotNull((Object)((Exception)streamRecord.getValue()), (Object)"Exception could not be `null`.");
        this.exceptions.add((Exception)streamRecord.getValue());
    }

    public void processWatermark(Watermark mark) throws Exception {
        if (this.startTime != 0L) {
            TaskResult response = new TaskResult(this.taskIndex, this.startTime, this.exceptions.isEmpty(), this.exceptions);
            this.output.collect((Object)new StreamRecord((Object)response));
            LOG.info("Aggregated result for table {}, task {}[{}] is {}", new Object[]{this.tableName, this.taskName, this.taskIndex, response});
            this.exceptions.clear();
            this.startTime = 0L;
        }
        super.processWatermark(mark);
    }
}

