/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.flink.sink.DeltaManifests;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Internal
public class DeltaManifestsSerializer
implements SimpleVersionedSerializer<DeltaManifests> {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final byte[] EMPTY_BINARY = new byte[0];
    public static final DeltaManifestsSerializer INSTANCE = new DeltaManifestsSerializer();

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(DeltaManifests deltaManifests) throws IOException {
        Preconditions.checkNotNull((Object)deltaManifests, (Object)"DeltaManifests to be serialized should not be null");
        ByteArrayOutputStream binaryOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(binaryOut);
        byte[] dataManifestBinary = EMPTY_BINARY;
        if (deltaManifests.dataManifest() != null) {
            dataManifestBinary = ManifestFiles.encode((ManifestFile)deltaManifests.dataManifest());
        }
        out.writeInt(dataManifestBinary.length);
        out.write(dataManifestBinary);
        byte[] deleteManifestBinary = EMPTY_BINARY;
        if (deltaManifests.deleteManifest() != null) {
            deleteManifestBinary = ManifestFiles.encode((ManifestFile)deltaManifests.deleteManifest());
        }
        out.writeInt(deleteManifestBinary.length);
        out.write(deleteManifestBinary);
        CharSequence[] referencedDataFiles = deltaManifests.referencedDataFiles();
        out.writeInt(referencedDataFiles.length);
        for (CharSequence referencedDataFile : referencedDataFiles) {
            out.writeUTF(referencedDataFile.toString());
        }
        return binaryOut.toByteArray();
    }

    public DeltaManifests deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            return this.deserializeV1(serialized);
        }
        if (version == 2) {
            return this.deserializeV2(serialized);
        }
        throw new RuntimeException("Unknown serialize version: " + version);
    }

    private DeltaManifests deserializeV1(byte[] serialized) throws IOException {
        return new DeltaManifests(ManifestFiles.decode((byte[])serialized), null);
    }

    private DeltaManifests deserializeV2(byte[] serialized) throws IOException {
        int deleteManifestSize;
        ManifestFile dataManifest = null;
        ManifestFile deleteManifest = null;
        ByteArrayInputStream binaryIn = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(binaryIn);
        int dataManifestSize = in.readInt();
        if (dataManifestSize > 0) {
            byte[] dataManifestBinary = new byte[dataManifestSize];
            Preconditions.checkState((in.read(dataManifestBinary) == dataManifestSize ? 1 : 0) != 0);
            dataManifest = ManifestFiles.decode((byte[])dataManifestBinary);
        }
        if ((deleteManifestSize = in.readInt()) > 0) {
            byte[] deleteManifestBinary = new byte[deleteManifestSize];
            Preconditions.checkState((in.read(deleteManifestBinary) == deleteManifestSize ? 1 : 0) != 0);
            deleteManifest = ManifestFiles.decode((byte[])deleteManifestBinary);
        }
        int referenceDataFileNum = in.readInt();
        CharSequence[] referencedDataFiles = new CharSequence[referenceDataFileNum];
        for (int i = 0; i < referenceDataFileNum; ++i) {
            referencedDataFiles[i] = in.readUTF();
        }
        return new DeltaManifests(dataManifest, deleteManifest, referencedDataFiles);
    }
}

