/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.StructProjection;

@Internal
public class EqualityFieldKeySelector
implements KeySelector<RowData, Integer> {
    private final Schema schema;
    private final RowType flinkSchema;
    private final Schema deleteSchema;
    private transient RowDataWrapper rowDataWrapper;
    private transient StructProjection structProjection;
    private transient StructLikeWrapper structLikeWrapper;

    public EqualityFieldKeySelector(Schema schema, RowType flinkSchema, Set<Integer> equalityFieldIds) {
        this.schema = schema;
        this.flinkSchema = flinkSchema;
        this.deleteSchema = TypeUtil.select((Schema)schema, equalityFieldIds);
    }

    protected RowDataWrapper lazyRowDataWrapper() {
        if (this.rowDataWrapper == null) {
            this.rowDataWrapper = new RowDataWrapper(this.flinkSchema, this.schema.asStruct());
        }
        return this.rowDataWrapper;
    }

    protected StructProjection lazyStructProjection() {
        if (this.structProjection == null) {
            this.structProjection = StructProjection.create((Schema)this.schema, (Schema)this.deleteSchema);
        }
        return this.structProjection;
    }

    protected StructLikeWrapper lazyStructLikeWrapper() {
        if (this.structLikeWrapper == null) {
            this.structLikeWrapper = StructLikeWrapper.forType((Types.StructType)this.deleteSchema.asStruct());
        }
        return this.structLikeWrapper;
    }

    public Integer getKey(RowData row) {
        RowDataWrapper wrappedRowData = this.lazyRowDataWrapper().wrap(row);
        StructProjection projectedRowData = this.lazyStructProjection().wrap((StructLike)wrappedRowData);
        StructLikeWrapper wrapper = this.lazyStructLikeWrapper().set((StructLike)projectedRowData);
        return wrapper.hashCode();
    }
}

