/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.sink.DeltaManifests;
import org.apache.iceberg.flink.sink.ManifestOutputFileFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkManifestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkManifestUtil.class);
    private static final int FORMAT_V2 = 2;
    private static final Long DUMMY_SNAPSHOT_ID = 0L;

    private FlinkManifestUtil() {
    }

    static ManifestFile writeDataFiles(OutputFile outputFile, PartitionSpec spec, List<DataFile> dataFiles) throws IOException {
        ManifestWriter writer;
        try (ManifestWriter closeableWriter = writer = ManifestFiles.write((int)2, (PartitionSpec)spec, (OutputFile)outputFile, (Long)DUMMY_SNAPSHOT_ID);){
            closeableWriter.addAll(dataFiles);
        }
        return writer.toManifestFile();
    }

    static List<DataFile> readDataFiles(ManifestFile manifestFile, FileIO io, Map<Integer, PartitionSpec> specsById) throws IOException {
        try (ManifestReader dataFiles = ManifestFiles.read((ManifestFile)manifestFile, (FileIO)io, specsById);){
            ArrayList arrayList = Lists.newArrayList((Iterable)dataFiles);
            return arrayList;
        }
    }

    public static ManifestOutputFileFactory createOutputFileFactory(Supplier<Table> tableSupplier, Map<String, String> tableProps, String flinkJobId, String operatorUniqueId, int subTaskId, long attemptNumber) {
        return new ManifestOutputFileFactory(tableSupplier, tableProps, flinkJobId, operatorUniqueId, subTaskId, attemptNumber);
    }

    public static DeltaManifests writeCompletedFiles(WriteResult result, Supplier<OutputFile> outputFileSupplier, PartitionSpec spec) throws IOException {
        ManifestFile dataManifest = null;
        ManifestFile deleteManifest = null;
        if (result.dataFiles() != null && result.dataFiles().length > 0) {
            dataManifest = FlinkManifestUtil.writeDataFiles(outputFileSupplier.get(), spec, Lists.newArrayList((Object[])result.dataFiles()));
        }
        if (result.deleteFiles() != null && result.deleteFiles().length > 0) {
            ManifestWriter deleteManifestWriter;
            OutputFile deleteManifestFile = outputFileSupplier.get();
            try (ManifestWriter writer = deleteManifestWriter = ManifestFiles.writeDeleteManifest((int)2, (PartitionSpec)spec, (OutputFile)deleteManifestFile, (Long)DUMMY_SNAPSHOT_ID);){
                for (DeleteFile deleteFile : result.deleteFiles()) {
                    writer.add((ContentFile)deleteFile);
                }
            }
            deleteManifest = deleteManifestWriter.toManifestFile();
        }
        return new DeltaManifests(dataManifest, deleteManifest, result.referencedDataFiles());
    }

    public static WriteResult readCompletedFiles(DeltaManifests deltaManifests, FileIO io, Map<Integer, PartitionSpec> specsById) throws IOException {
        WriteResult.Builder builder = WriteResult.builder();
        if (deltaManifests.dataManifest() != null) {
            builder.addDataFiles(FlinkManifestUtil.readDataFiles(deltaManifests.dataManifest(), io, specsById));
        }
        if (deltaManifests.deleteManifest() != null) {
            try (ManifestReader deleteFiles = ManifestFiles.readDeleteManifest((ManifestFile)deltaManifests.deleteManifest(), (FileIO)io, specsById);){
                builder.addDeleteFiles((Iterable)deleteFiles);
            }
        }
        return builder.addReferencedDataFiles(deltaManifests.referencedDataFiles()).build();
    }

    public static void deleteCommittedManifests(Table table, List<ManifestFile> manifests, String newFlinkJobId, long checkpointId) {
        FlinkManifestUtil.deleteCommittedManifests(table.name(), table.io(), manifests, newFlinkJobId, checkpointId);
    }

    static void deleteCommittedManifests(String tableName, FileIO io, List<ManifestFile> manifestsPath, String newFlinkJobId, long checkpointId) {
        for (ManifestFile manifest : manifestsPath) {
            try {
                io.deleteFile(manifest.path());
            }
            catch (Exception e) {
                String details = MoreObjects.toStringHelper(FlinkManifestUtil.class).add("tableName", (Object)tableName).add("flinkJobId", (Object)newFlinkJobId).add("checkpointId", checkpointId).add("manifestPath", (Object)manifest).toString();
                LOG.warn("The iceberg transaction has been committed, but we failed to clean the temporary flink manifests: {}", (Object)details, (Object)e);
            }
        }
    }
}

