/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;
import org.apache.flink.dropwizard.metrics.DropwizardHistogramWrapper;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.util.ScanTaskUtil;

@Internal
public class IcebergStreamWriterMetrics {
    private static final int HISTOGRAM_RESERVOIR_SIZE = 1024;
    private final Counter flushedDataFiles;
    private final Counter flushedDeleteFiles;
    private final Counter flushedReferencedDataFiles;
    private final AtomicLong lastFlushDurationMs;
    private final org.apache.flink.metrics.Histogram dataFilesSizeHistogram;
    private final org.apache.flink.metrics.Histogram deleteFilesSizeHistogram;

    public IcebergStreamWriterMetrics(MetricGroup metrics, String fullTableName) {
        MetricGroup writerMetrics = metrics.addGroup("IcebergStreamWriter").addGroup("table", fullTableName);
        this.flushedDataFiles = writerMetrics.counter("flushedDataFiles");
        this.flushedDeleteFiles = writerMetrics.counter("flushedDeleteFiles");
        this.flushedReferencedDataFiles = writerMetrics.counter("flushedReferencedDataFiles");
        this.lastFlushDurationMs = new AtomicLong();
        writerMetrics.gauge("lastFlushDurationMs", this.lastFlushDurationMs::get);
        Histogram dropwizardDataFilesSizeHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(1024));
        this.dataFilesSizeHistogram = writerMetrics.histogram("dataFilesSizeHistogram", (org.apache.flink.metrics.Histogram)new DropwizardHistogramWrapper(dropwizardDataFilesSizeHistogram));
        Histogram dropwizardDeleteFilesSizeHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(1024));
        this.deleteFilesSizeHistogram = writerMetrics.histogram("deleteFilesSizeHistogram", (org.apache.flink.metrics.Histogram)new DropwizardHistogramWrapper(dropwizardDeleteFilesSizeHistogram));
    }

    public void updateFlushResult(WriteResult result) {
        this.flushedDataFiles.inc((long)result.dataFiles().length);
        this.flushedDeleteFiles.inc((long)result.deleteFiles().length);
        this.flushedReferencedDataFiles.inc((long)result.referencedDataFiles().length);
        Arrays.stream(result.dataFiles()).forEach(dataFile -> this.dataFilesSizeHistogram.update(dataFile.fileSizeInBytes()));
        Arrays.stream(result.deleteFiles()).forEach(deleteFile -> this.deleteFilesSizeHistogram.update(ScanTaskUtil.contentSizeInBytes((ContentFile)deleteFile)));
    }

    public void flushDuration(long flushDurationMs) {
        this.lastFlushDurationMs.set(flushDurationMs);
    }

    public Counter getFlushedDataFiles() {
        return this.flushedDataFiles;
    }

    public Counter getFlushedDeleteFiles() {
        return this.flushedDeleteFiles;
    }
}

