/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Set;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.sink.BaseDeltaTaskWriter;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Tasks;

class PartitionedDeltaWriter
extends BaseDeltaTaskWriter {
    private final PartitionKey partitionKey;
    private final Map<PartitionKey, BaseDeltaTaskWriter.RowDataDeltaWriter> writers = Maps.newHashMap();

    PartitionedDeltaWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<RowData> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, RowType flinkSchema, Set<Integer> equalityFieldIds, boolean upsert) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize, schema, flinkSchema, equalityFieldIds, upsert);
        this.partitionKey = new PartitionKey(spec, schema);
    }

    @Override
    BaseDeltaTaskWriter.RowDataDeltaWriter route(RowData row) {
        this.partitionKey.partition((StructLike)this.wrapper().wrap(row));
        BaseDeltaTaskWriter.RowDataDeltaWriter writer = this.writers.get(this.partitionKey);
        if (writer == null) {
            PartitionKey copiedKey = this.partitionKey.copy();
            writer = new BaseDeltaTaskWriter.RowDataDeltaWriter(copiedKey);
            this.writers.put(copiedKey, writer);
        }
        return writer;
    }

    public void close() {
        try {
            Tasks.foreach(this.writers.values()).throwFailureWhenFinished().noRetry().run(BaseTaskWriter.BaseEqualityDeltaWriter::close, IOException.class);
            this.writers.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close equality delta writer", e);
        }
    }
}

