/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkWriteConf;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SinkUtil {
    private static final long INITIAL_CHECKPOINT_ID = -1L;
    public static final String FLINK_JOB_ID = "flink.job-id";
    public static final String OPERATOR_ID = "flink.operator-id";
    public static final String MAX_COMMITTED_CHECKPOINT_ID = "flink.max-committed-checkpoint-id";
    private static final Logger LOG = LoggerFactory.getLogger(SinkUtil.class);

    private SinkUtil() {
    }

    static Set<Integer> checkAndGetEqualityFieldIds(Table table, List<String> equalityFieldColumns) {
        HashSet equalityFieldIds = Sets.newHashSet((Iterable)table.schema().identifierFieldIds());
        if (equalityFieldColumns != null && !equalityFieldColumns.isEmpty()) {
            HashSet equalityFieldSet = Sets.newHashSetWithExpectedSize((int)equalityFieldColumns.size());
            for (String column : equalityFieldColumns) {
                Types.NestedField field = table.schema().findField(column);
                Preconditions.checkNotNull((Object)field, (String)"Missing required equality field column '%s' in table schema %s", (Object)column, (Object)table.schema());
                equalityFieldSet.add(field.fieldId());
            }
            if (!equalityFieldSet.equals(table.schema().identifierFieldIds())) {
                LOG.warn("The configured equality field column IDs {} are not matched with the schema identifier field IDs {}, use job specified equality field columns as the equality fields by default.", (Object)equalityFieldSet, (Object)table.schema().identifierFieldIds());
            }
            equalityFieldIds = Sets.newHashSet((Iterable)equalityFieldSet);
        }
        return equalityFieldIds;
    }

    static long getMaxCommittedCheckpointId(Table table, String flinkJobId, String operatorId, String branch) {
        Snapshot snapshot = table.snapshot(branch);
        long lastCommittedCheckpointId = -1L;
        while (snapshot != null) {
            String value;
            Map summary = snapshot.summary();
            String snapshotFlinkJobId = (String)summary.get(FLINK_JOB_ID);
            String snapshotOperatorId = (String)summary.get(OPERATOR_ID);
            if (flinkJobId.equals(snapshotFlinkJobId) && (snapshotOperatorId == null || snapshotOperatorId.equals(operatorId)) && (value = (String)summary.get(MAX_COMMITTED_CHECKPOINT_ID)) != null) {
                lastCommittedCheckpointId = Long.parseLong(value);
                break;
            }
            Long parentSnapshotId = snapshot.parentId();
            snapshot = parentSnapshotId != null ? table.snapshot(parentSnapshotId.longValue()) : null;
        }
        return lastCommittedCheckpointId;
    }

    public static Map<String, String> writeProperties(FileFormat format, FlinkWriteConf conf, @Nullable Table table) {
        HashMap writeProperties = Maps.newHashMap();
        if (table != null) {
            writeProperties.putAll(table.properties());
        }
        switch (format) {
            case PARQUET: {
                writeProperties.put("write.parquet.compression-codec", conf.parquetCompressionCodec());
                String parquetCompressionLevel = conf.parquetCompressionLevel();
                if (parquetCompressionLevel == null) break;
                writeProperties.put("write.parquet.compression-level", parquetCompressionLevel);
                break;
            }
            case AVRO: {
                writeProperties.put("write.avro.compression-codec", conf.avroCompressionCodec());
                String avroCompressionLevel = conf.avroCompressionLevel();
                if (avroCompressionLevel == null) break;
                writeProperties.put("write.avro.compression-level", conf.avroCompressionLevel());
                break;
            }
            case ORC: {
                writeProperties.put("write.orc.compression-codec", conf.orcCompressionCodec());
                writeProperties.put("write.orc.compression-strategy", conf.orcCompressionStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown file format %s", format));
            }
        }
        return writeProperties;
    }
}

