/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class CompareSchemasVisitor
extends SchemaWithPartnerVisitor<Integer, Result> {
    private final Schema tableSchema;

    private CompareSchemasVisitor(Schema tableSchema) {
        this.tableSchema = tableSchema;
    }

    public static Result visit(Schema dataSchema, Schema tableSchema) {
        return CompareSchemasVisitor.visit(dataSchema, tableSchema, true);
    }

    public static Result visit(Schema dataSchema, Schema tableSchema, boolean caseSensitive) {
        return (Result)((Object)CompareSchemasVisitor.visit((Schema)dataSchema, (Object)-1, (SchemaWithPartnerVisitor)new CompareSchemasVisitor(tableSchema), (SchemaWithPartnerVisitor.PartnerAccessors)new PartnerIdByNameAccessors(tableSchema, caseSensitive)));
    }

    public Result schema(Schema dataSchema, Integer tableSchemaId, Result downstream) {
        if (tableSchemaId == null) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        return downstream;
    }

    public Result struct(Types.StructType struct, Integer tableSchemaId, List<Result> fields) {
        Types.StructType tableSchemaType;
        if (tableSchemaId == null) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        Result result = fields.stream().reduce((rec$, x$0) -> ((Result)((Object)((Object)rec$))).merge((Result)((Object)x$0))).orElse(Result.SCHEMA_UPDATE_NEEDED);
        if (result == Result.SCHEMA_UPDATE_NEEDED) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        Object object = tableSchemaType = tableSchemaId == -1 ? this.tableSchema.asStruct() : this.tableSchema.findField(tableSchemaId.intValue()).type();
        if (!tableSchemaType.isStructType()) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        for (Types.NestedField tableField : tableSchemaType.asStructType().fields()) {
            if (!tableField.isRequired() || struct.field(tableField.name()) != null) continue;
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        if (struct.fields().size() != tableSchemaType.asStructType().fields().size()) {
            return Result.DATA_CONVERSION_NEEDED;
        }
        for (int i = 0; i < struct.fields().size(); ++i) {
            if (((Types.NestedField)struct.fields().get(i)).name().equals(((Types.NestedField)tableSchemaType.asStructType().fields().get(i)).name())) continue;
            return Result.DATA_CONVERSION_NEEDED;
        }
        return result;
    }

    public Result field(Types.NestedField field, Integer tableSchemaId, Result typeResult) {
        if (tableSchemaId == null) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        if (typeResult != Result.SAME) {
            return typeResult;
        }
        if (this.tableSchema.findField(tableSchemaId.intValue()).isRequired() && field.isOptional()) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        return Result.SAME;
    }

    public Result list(Types.ListType list, Integer tableSchemaId, Result elementsResult) {
        if (tableSchemaId == null) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        return elementsResult;
    }

    public Result map(Types.MapType map, Integer tableSchemaId, Result keyResult, Result valueResult) {
        if (tableSchemaId == null) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        return keyResult.merge(valueResult);
    }

    public Result primitive(Type.PrimitiveType primitive, Integer tableSchemaId) {
        if (tableSchemaId == null) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        Type tableSchemaType = this.tableSchema.findField(tableSchemaId.intValue()).type();
        if (!tableSchemaType.isPrimitiveType()) {
            return Result.SCHEMA_UPDATE_NEEDED;
        }
        Type.PrimitiveType tableSchemaPrimitiveType = tableSchemaType.asPrimitiveType();
        if (primitive.equals((Object)tableSchemaPrimitiveType)) {
            return Result.SAME;
        }
        if (primitive.equals((Object)Types.IntegerType.get()) && tableSchemaPrimitiveType.equals((Object)Types.LongType.get())) {
            return Result.DATA_CONVERSION_NEEDED;
        }
        if (primitive.equals((Object)Types.FloatType.get()) && tableSchemaPrimitiveType.equals((Object)Types.DoubleType.get())) {
            return Result.DATA_CONVERSION_NEEDED;
        }
        if (primitive.equals((Object)Types.DateType.get()) && tableSchemaPrimitiveType.equals((Object)Types.TimestampType.withoutZone())) {
            return Result.DATA_CONVERSION_NEEDED;
        }
        if (primitive.typeId() == Type.TypeID.DECIMAL && tableSchemaPrimitiveType.typeId() == Type.TypeID.DECIMAL) {
            Types.DecimalType dataType = (Types.DecimalType)primitive;
            Types.DecimalType tableType = (Types.DecimalType)tableSchemaPrimitiveType;
            return dataType.scale() == tableType.scale() && dataType.precision() < tableType.precision() ? Result.DATA_CONVERSION_NEEDED : Result.SCHEMA_UPDATE_NEEDED;
        }
        return Result.SCHEMA_UPDATE_NEEDED;
    }

    public static enum Result {
        SAME(0),
        DATA_CONVERSION_NEEDED(1),
        SCHEMA_UPDATE_NEEDED(2);

        private static final Map<Integer, Result> BY_ID;
        private final int id;

        private Result(int id) {
            this.id = id;
        }

        private Result merge(Result other) {
            return BY_ID.get(Math.max(this.id, other.id));
        }

        static {
            BY_ID = Maps.newHashMap();
            for (Result e : Result.values()) {
                if (BY_ID.put(e.id, e) == null) continue;
                throw new IllegalArgumentException("Duplicate id: " + e.id);
            }
        }
    }

    static class PartnerIdByNameAccessors
    implements SchemaWithPartnerVisitor.PartnerAccessors<Integer> {
        private final Schema tableSchema;
        private boolean caseSensitive = true;

        PartnerIdByNameAccessors(Schema tableSchema) {
            this.tableSchema = tableSchema;
        }

        private PartnerIdByNameAccessors(Schema tableSchema, boolean caseSensitive) {
            this(tableSchema);
            this.caseSensitive = caseSensitive;
        }

        public Integer fieldPartner(Integer tableSchemaFieldId, int fieldId, String name) {
            Types.NestedField field;
            Types.StructType struct = tableSchemaFieldId == -1 ? this.tableSchema.asStruct() : this.tableSchema.findField(tableSchemaFieldId.intValue()).type().asStructType();
            Types.NestedField nestedField = field = this.caseSensitive ? struct.field(name) : struct.caseInsensitiveField(name);
            if (field != null) {
                return field.fieldId();
            }
            return null;
        }

        public Integer mapKeyPartner(Integer tableSchemaMapId) {
            Types.NestedField mapField = this.tableSchema.findField(tableSchemaMapId.intValue());
            if (mapField != null) {
                return ((Types.NestedField)mapField.type().asMapType().fields().get(0)).fieldId();
            }
            return null;
        }

        public Integer mapValuePartner(Integer tableSchemaMapId) {
            Types.NestedField mapField = this.tableSchema.findField(tableSchemaMapId.intValue());
            if (mapField != null) {
                return ((Types.NestedField)mapField.type().asMapType().fields().get(1)).fieldId();
            }
            return null;
        }

        public Integer listElementPartner(Integer tableSchemaListId) {
            Types.NestedField listField = this.tableSchema.findField(tableSchemaListId.intValue());
            if (listField != null) {
                return ((Types.NestedField)listField.type().asListType().fields().get(0)).fieldId();
            }
            return null;
        }
    }
}

