/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

interface DataConverter {
    public Object convert(Object var1);

    public static DataConverter identity() {
        return object -> object;
    }

    public static DataConverter getNullable(LogicalType sourceType, LogicalType targetType) {
        return DataConverter.nullable(DataConverter.get(sourceType, targetType));
    }

    public static DataConverter get(LogicalType sourceType, LogicalType targetType) {
        switch (targetType.getTypeRoot()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case VARCHAR: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case BINARY: 
            case VARBINARY: {
                return object -> object;
            }
            case DOUBLE: {
                return object -> {
                    if (object instanceof Float) {
                        return ((Float)object).doubleValue();
                    }
                    return object;
                };
            }
            case BIGINT: {
                return object -> {
                    if (object instanceof Integer) {
                        return ((Integer)object).longValue();
                    }
                    return object;
                };
            }
            case DECIMAL: {
                return object -> {
                    DecimalType toDecimalType = (DecimalType)targetType;
                    DecimalData decimalData = (DecimalData)object;
                    if (((DecimalType)sourceType).getPrecision() == toDecimalType.getPrecision()) {
                        return object;
                    }
                    return DecimalData.fromBigDecimal((BigDecimal)decimalData.toBigDecimal(), (int)toDecimalType.getPrecision(), (int)toDecimalType.getScale());
                };
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return object -> {
                    if (object instanceof Integer) {
                        LocalDateTime dateTime = LocalDateTime.of(LocalDate.ofEpochDay(((Integer)object).intValue()), LocalTime.MIN);
                        return TimestampData.fromLocalDateTime((LocalDateTime)dateTime);
                    }
                    return object;
                };
            }
            case ROW: {
                return new RowDataConverter((RowType)sourceType, (RowType)targetType);
            }
            case ARRAY: {
                return new ArrayConverter((ArrayType)sourceType, (ArrayType)targetType);
            }
            case MAP: {
                return new MapConverter((MapType)sourceType, (MapType)targetType);
            }
        }
        throw new UnsupportedOperationException("Not a supported type: " + String.valueOf(targetType));
    }

    public static DataConverter nullable(DataConverter converter) {
        return value -> value == null ? null : converter.convert(value);
    }

    public static class RowDataConverter
    implements DataConverter {
        private final RowData.FieldGetter[] fieldGetters;
        private final DataConverter[] dataConverters;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        RowDataConverter(RowType sourceType, RowType targetType) {
            this.fieldGetters = new RowData.FieldGetter[targetType.getFields().size()];
            this.dataConverters = new DataConverter[targetType.getFields().size()];
            for (int i = 0; i < targetType.getFields().size(); ++i) {
                DataConverter dataConverter;
                RowData.FieldGetter fieldGetter;
                RowType.RowField targetField = (RowType.RowField)targetType.getFields().get(i);
                int sourceFieldIndex = sourceType.getFieldIndex(targetField.getName());
                if (sourceFieldIndex == -1) {
                    if (!targetField.getType().isNullable()) throw new IllegalArgumentException(String.format("Field %s in target schema %s is non-nullable but does not exist in source schema.", i + 1, targetType));
                    fieldGetter = row -> null;
                    dataConverter = value -> null;
                } else {
                    RowType.RowField sourceField = (RowType.RowField)sourceType.getFields().get(sourceFieldIndex);
                    fieldGetter = RowData.createFieldGetter((LogicalType)sourceField.getType(), (int)sourceFieldIndex);
                    dataConverter = DataConverter.getNullable(sourceField.getType(), targetField.getType());
                }
                this.fieldGetters[i] = fieldGetter;
                this.dataConverters[i] = dataConverter;
            }
        }

        public RowData convert(Object object) {
            RowData sourceData = (RowData)object;
            GenericRowData targetData = new GenericRowData(this.fieldGetters.length);
            for (int i = 0; i < this.fieldGetters.length; ++i) {
                Object value = this.fieldGetters[i].getFieldOrNull(sourceData);
                targetData.setField(i, this.dataConverters[i].convert(value));
            }
            return targetData;
        }
    }

    public static class ArrayConverter
    implements DataConverter {
        private final ArrayData.ElementGetter elementGetter;
        private final DataConverter elementConverter;

        ArrayConverter(ArrayType sourceType, ArrayType targetType) {
            this.elementGetter = ArrayData.createElementGetter((LogicalType)sourceType.getElementType());
            this.elementConverter = DataConverter.getNullable(sourceType.getElementType(), targetType.getElementType());
        }

        public ArrayData convert(Object object) {
            ArrayData arrayData = (ArrayData)object;
            Object[] convertedArray = new Object[arrayData.size()];
            for (int i = 0; i < convertedArray.length; ++i) {
                Object element = this.elementGetter.getElementOrNull(arrayData, i);
                convertedArray[i] = this.elementConverter.convert(element);
            }
            return new GenericArrayData(convertedArray);
        }
    }

    public static class MapConverter
    implements DataConverter {
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;
        private final DataConverter keyConverter;
        private final DataConverter valueConverter;

        MapConverter(MapType sourceType, MapType targetType) {
            this.keyGetter = ArrayData.createElementGetter((LogicalType)sourceType.getKeyType());
            this.valueGetter = ArrayData.createElementGetter((LogicalType)sourceType.getValueType());
            this.keyConverter = DataConverter.getNullable(sourceType.getKeyType(), targetType.getKeyType());
            this.valueConverter = DataConverter.getNullable(sourceType.getValueType(), targetType.getValueType());
        }

        public MapData convert(Object object) {
            MapData sourceData = (MapData)object;
            ArrayData keyArray = sourceData.keyArray();
            ArrayData valueArray = sourceData.valueArray();
            LinkedHashMap convertedMap = Maps.newLinkedHashMap();
            for (int i = 0; i < keyArray.size(); ++i) {
                convertedMap.put(this.keyConverter.convert(this.keyGetter.getElementOrNull(keyArray, i)), this.valueConverter.convert(this.valueGetter.getElementOrNull(valueArray, i)));
            }
            return new GenericMapData((Map)convertedMap);
        }
    }
}

