/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iceberg.flink.sink.dynamic.WriteTarget;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class DynamicCommittable
implements Serializable {
    private final WriteTarget key;
    private final byte[] manifest;
    private final String jobId;
    private final String operatorId;
    private final long checkpointId;

    DynamicCommittable(WriteTarget key, byte[] manifest, String jobId, String operatorId, long checkpointId) {
        this.key = key;
        this.manifest = manifest;
        this.jobId = jobId;
        this.operatorId = operatorId;
        this.checkpointId = checkpointId;
    }

    WriteTarget key() {
        return this.key;
    }

    byte[] manifest() {
        return this.manifest;
    }

    String jobId() {
        return this.jobId;
    }

    String operatorId() {
        return this.operatorId;
    }

    long checkpointId() {
        return this.checkpointId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicCommittable that = (DynamicCommittable)o;
        return this.checkpointId == that.checkpointId && Objects.equals(this.key, that.key) && Objects.deepEquals(this.manifest, that.manifest) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.operatorId, that.operatorId);
    }

    public int hashCode() {
        return Objects.hash(this.key, Arrays.hashCode(this.manifest), this.jobId, this.operatorId, this.checkpointId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("jobId", (Object)this.jobId).add("checkpointId", this.checkpointId).add("operatorId", (Object)this.operatorId).toString();
    }

    public WriteTarget writeTarget() {
        return this.key;
    }
}

