/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.iceberg.flink.sink.dynamic.DynamicCommittable;
import org.apache.iceberg.flink.sink.dynamic.WriteTarget;

class DynamicCommittableSerializer
implements SimpleVersionedSerializer<DynamicCommittable> {
    private static final int VERSION = 1;

    DynamicCommittableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DynamicCommittable committable) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        committable.key().serializeTo((DataOutputView)view);
        view.writeUTF(committable.jobId());
        view.writeUTF(committable.operatorId());
        view.writeLong(committable.checkpointId());
        view.writeInt(committable.manifest().length);
        view.write(committable.manifest());
        return out.toByteArray();
    }

    public DynamicCommittable deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            DataInputDeserializer view = new DataInputDeserializer(serialized);
            WriteTarget key = WriteTarget.deserializeFrom((DataInputView)view);
            String jobId = view.readUTF();
            String operatorId = view.readUTF();
            long checkpointId = view.readLong();
            int manifestLen = view.readInt();
            byte[] manifestBuf = new byte[manifestLen];
            view.read(manifestBuf);
            return new DynamicCommittable(key, manifestBuf, jobId, operatorId, checkpointId);
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }
}

