/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.hadoop.util.Sets;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.flink.sink.dynamic.DynamicRecordInternal;
import org.apache.iceberg.flink.sink.dynamic.TableSerializerCache;

@Internal
class DynamicRecordInternalSerializer
extends TypeSerializer<DynamicRecordInternal> {
    private static final long serialVersionUID = 1L;
    private final TableSerializerCache serializerCache;
    private final boolean writeSchemaAndSpec;

    DynamicRecordInternalSerializer(TableSerializerCache serializerCache, boolean writeSchemaAndSpec) {
        this.serializerCache = serializerCache;
        this.writeSchemaAndSpec = writeSchemaAndSpec;
    }

    public TypeSerializer<DynamicRecordInternal> duplicate() {
        return new DynamicRecordInternalSerializer(new TableSerializerCache(this.serializerCache.catalogLoader(), this.serializerCache.maximumSize()), this.writeSchemaAndSpec);
    }

    public DynamicRecordInternal createInstance() {
        return new DynamicRecordInternal();
    }

    public void serialize(DynamicRecordInternal toSerialize, DataOutputView dataOutputView) throws IOException {
        RowDataSerializer rowDataSerializer;
        dataOutputView.writeUTF(toSerialize.tableName());
        dataOutputView.writeUTF(toSerialize.branch());
        if (this.writeSchemaAndSpec) {
            dataOutputView.writeUTF(SchemaParser.toJson((Schema)toSerialize.schema()));
            dataOutputView.writeUTF(PartitionSpecParser.toJson((PartitionSpec)toSerialize.spec()));
        } else {
            dataOutputView.writeInt(toSerialize.schema().schemaId());
            dataOutputView.writeInt(toSerialize.spec().specId());
        }
        dataOutputView.writeInt(toSerialize.writerKey());
        if (this.writeSchemaAndSpec) {
            rowDataSerializer = this.serializerCache.serializer(toSerialize.tableName(), toSerialize.schema(), toSerialize.spec());
        } else {
            Tuple3<RowDataSerializer, Schema, PartitionSpec> serializer = this.serializerCache.serializerWithSchemaAndSpec(toSerialize.tableName(), toSerialize.schema().schemaId(), toSerialize.spec().specId());
            rowDataSerializer = (RowDataSerializer)serializer.f0;
        }
        rowDataSerializer.serialize(toSerialize.rowData(), dataOutputView);
        dataOutputView.writeBoolean(toSerialize.upsertMode());
        dataOutputView.writeInt(toSerialize.equalityFields().size());
        for (Integer equalityField : toSerialize.equalityFields()) {
            dataOutputView.writeInt(equalityField.intValue());
        }
    }

    public DynamicRecordInternal deserialize(DataInputView dataInputView) throws IOException {
        RowDataSerializer rowDataSerializer;
        PartitionSpec spec;
        Schema schema;
        String tableName = dataInputView.readUTF();
        String branch = dataInputView.readUTF();
        if (this.writeSchemaAndSpec) {
            schema = SchemaParser.fromJson((String)dataInputView.readUTF());
            spec = PartitionSpecParser.fromJson((Schema)schema, (String)dataInputView.readUTF());
            rowDataSerializer = this.serializerCache.serializer(tableName, schema, spec);
        } else {
            Integer schemaId = dataInputView.readInt();
            Integer specId = dataInputView.readInt();
            Tuple3<RowDataSerializer, Schema, PartitionSpec> serializerWithSchemaAndSpec = this.serializerCache.serializerWithSchemaAndSpec(tableName, schemaId, specId);
            schema = (Schema)serializerWithSchemaAndSpec.f1;
            spec = (PartitionSpec)serializerWithSchemaAndSpec.f2;
            rowDataSerializer = (RowDataSerializer)serializerWithSchemaAndSpec.f0;
        }
        int writerKey = dataInputView.readInt();
        RowData rowData = rowDataSerializer.deserialize(dataInputView);
        boolean upsertMode = dataInputView.readBoolean();
        int numEqualityFields = dataInputView.readInt();
        HashSet equalityFieldIds = numEqualityFields > 0 ? Sets.newHashSetWithExpectedSize((int)numEqualityFields) : Collections.emptySet();
        for (int i = 0; i < numEqualityFields; ++i) {
            equalityFieldIds.add(dataInputView.readInt());
        }
        return new DynamicRecordInternal(tableName, branch, schema, rowData, spec, writerKey, upsertMode, equalityFieldIds);
    }

    public DynamicRecordInternal deserialize(DynamicRecordInternal reuse, DataInputView dataInputView) throws IOException {
        RowDataSerializer rowDataSerializer;
        PartitionSpec spec;
        Schema schema;
        String tableName = dataInputView.readUTF();
        reuse.setTableName(tableName);
        String branch = dataInputView.readUTF();
        reuse.setBranch(branch);
        if (this.writeSchemaAndSpec) {
            schema = SchemaParser.fromJson((String)dataInputView.readUTF());
            spec = PartitionSpecParser.fromJson((Schema)schema, (String)dataInputView.readUTF());
            reuse.setSchema(schema);
            reuse.setSpec(spec);
            rowDataSerializer = this.serializerCache.serializer(tableName, schema, spec);
        } else {
            Integer schemaId = dataInputView.readInt();
            Integer specId = dataInputView.readInt();
            Tuple3<RowDataSerializer, Schema, PartitionSpec> serializerWithSchemaAndSpec = this.serializerCache.serializerWithSchemaAndSpec(tableName, schemaId, specId);
            schema = (Schema)serializerWithSchemaAndSpec.f1;
            spec = (PartitionSpec)serializerWithSchemaAndSpec.f2;
            rowDataSerializer = (RowDataSerializer)serializerWithSchemaAndSpec.f0;
        }
        int writerKey = dataInputView.readInt();
        reuse.setWriterKey(writerKey);
        RowData rowData = rowDataSerializer.deserialize(dataInputView);
        boolean upsertMode = dataInputView.readBoolean();
        int numEqualityFields = dataInputView.readInt();
        HashSet equalityFieldIds = numEqualityFields > 0 ? Sets.newHashSetWithExpectedSize((int)numEqualityFields) : Collections.emptySet();
        for (int i = 0; i < numEqualityFields; ++i) {
            equalityFieldIds.add(dataInputView.readInt());
        }
        return new DynamicRecordInternal(tableName, branch, schema, rowData, spec, writerKey, upsertMode, equalityFieldIds);
    }

    public DynamicRecordInternal copy(DynamicRecordInternal from) {
        return new DynamicRecordInternal(from.tableName(), from.branch(), from.schema(), from.rowData(), from.spec(), from.writerKey(), from.upsertMode(), from.equalityFields());
    }

    public DynamicRecordInternal copy(DynamicRecordInternal from, DynamicRecordInternal reuse) {
        reuse.setTableName(from.tableName());
        reuse.setBranch(from.branch());
        reuse.setSchema(from.schema());
        reuse.setSpec(from.spec());
        reuse.setWriterKey(from.writerKey());
        reuse.setRowData(from.rowData());
        reuse.setUpsertMode(from.upsertMode());
        reuse.setEqualityFieldIds(from.equalityFields());
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DynamicRecordInternalSerializer) {
            DynamicRecordInternalSerializer other = (DynamicRecordInternalSerializer)((Object)obj);
            return this.writeSchemaAndSpec == other.writeSchemaAndSpec;
        }
        return false;
    }

    public int hashCode() {
        return Boolean.hashCode(this.writeSchemaAndSpec);
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public TypeSerializerSnapshot<DynamicRecordInternal> snapshotConfiguration() {
        return new DynamicRecordInternalTypeSerializerSnapshot(this.writeSchemaAndSpec);
    }

    public static class DynamicRecordInternalTypeSerializerSnapshot
    implements TypeSerializerSnapshot<DynamicRecordInternal> {
        private boolean writeSchemaAndSpec;

        public DynamicRecordInternalTypeSerializerSnapshot() {
        }

        DynamicRecordInternalTypeSerializerSnapshot(boolean writeSchemaAndSpec) {
            this.writeSchemaAndSpec = writeSchemaAndSpec;
        }

        public int getCurrentVersion() {
            return 0;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeBoolean(this.writeSchemaAndSpec);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.writeSchemaAndSpec = in.readBoolean();
        }

        public TypeSerializerSchemaCompatibility<DynamicRecordInternal> resolveSchemaCompatibility(TypeSerializerSnapshot<DynamicRecordInternal> oldSerializerSnapshot) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }

        public TypeSerializer<DynamicRecordInternal> restoreSerializer() {
            return new DynamicRecordInternalSerializer(null, this.writeSchemaAndSpec);
        }
    }
}

