/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.sink.dynamic.DynamicRecordInternal;
import org.apache.iceberg.flink.sink.dynamic.TableMetadataCache;
import org.apache.iceberg.flink.sink.dynamic.TableUpdater;

@Internal
class DynamicTableUpdateOperator
extends RichMapFunction<DynamicRecordInternal, DynamicRecordInternal> {
    private final CatalogLoader catalogLoader;
    private final int cacheMaximumSize;
    private final long cacheRefreshMs;
    private final int inputSchemasPerTableCacheMaximumSize;
    private transient TableUpdater updater;

    DynamicTableUpdateOperator(CatalogLoader catalogLoader, int cacheMaximumSize, long cacheRefreshMs, int inputSchemasPerTableCacheMaximumSize) {
        this.catalogLoader = catalogLoader;
        this.cacheMaximumSize = cacheMaximumSize;
        this.cacheRefreshMs = cacheRefreshMs;
        this.inputSchemasPerTableCacheMaximumSize = inputSchemasPerTableCacheMaximumSize;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        Catalog catalog = this.catalogLoader.loadCatalog();
        this.updater = new TableUpdater(new TableMetadataCache(catalog, this.cacheMaximumSize, this.cacheRefreshMs, this.inputSchemasPerTableCacheMaximumSize), catalog);
    }

    public DynamicRecordInternal map(DynamicRecordInternal data) throws Exception {
        Tuple2<TableMetadataCache.ResolvedSchemaInfo, PartitionSpec> newData = this.updater.update(TableIdentifier.parse((String)data.tableName()), data.branch(), data.schema(), data.spec());
        TableMetadataCache.ResolvedSchemaInfo compareInfo = (TableMetadataCache.ResolvedSchemaInfo)newData.f0;
        data.setSchema(compareInfo.resolvedTableSchema());
        data.setSpec((PartitionSpec)newData.f1);
        RowData newRowData = (RowData)((TableMetadataCache.ResolvedSchemaInfo)newData.f0).recordConverter().convert(data.rowData());
        data.setRowData(newRowData);
        return data;
    }
}

