/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.flink.sink.dynamic.CompareSchemasVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class EvolveSchemaVisitor
extends SchemaWithPartnerVisitor<Integer, Boolean> {
    private final UpdateSchema api;
    private final Schema existingSchema;
    private final Schema targetSchema;

    private EvolveSchemaVisitor(UpdateSchema api, Schema existingSchema, Schema targetSchema) {
        this.api = api;
        this.existingSchema = existingSchema;
        this.targetSchema = targetSchema;
    }

    public static void visit(UpdateSchema api, Schema existingSchema, Schema targetSchema) {
        EvolveSchemaVisitor.visit((Schema)targetSchema, (Object)-1, (SchemaWithPartnerVisitor)new EvolveSchemaVisitor(api, existingSchema, targetSchema), (SchemaWithPartnerVisitor.PartnerAccessors)new CompareSchemasVisitor.PartnerIdByNameAccessors(existingSchema));
    }

    public Boolean struct(Types.StructType struct, Integer partnerId, List<Boolean> existingFields) {
        if (partnerId == null) {
            return true;
        }
        Types.StructType partnerStruct = this.findFieldType(partnerId).asStructType();
        String after = null;
        for (Types.NestedField targetField : struct.fields()) {
            String columnName;
            Types.NestedField nestedField = partnerStruct.field(targetField.name());
            if (nestedField != null) {
                this.updateColumn(nestedField, targetField);
                columnName = this.existingSchema.findColumnName(nestedField.fieldId());
            } else {
                this.addColumn(partnerId, targetField);
                columnName = this.targetSchema.findColumnName(targetField.fieldId());
            }
            this.setPosition(columnName, after);
            after = columnName;
        }
        for (Types.NestedField existingField : partnerStruct.fields()) {
            if (struct.field(existingField.name()) != null || !existingField.isRequired()) continue;
            this.api.makeColumnOptional(this.existingSchema.findColumnName(existingField.fieldId()));
        }
        return false;
    }

    public Boolean field(Types.NestedField field, Integer partnerId, Boolean isFieldMissing) {
        return partnerId == null;
    }

    public Boolean list(Types.ListType list, Integer partnerId, Boolean isElementMissing) {
        if (partnerId == null) {
            return true;
        }
        Preconditions.checkState((isElementMissing == false ? 1 : 0) != 0, (Object)"Error traversing schemas: element is missing, but list is present");
        Types.ListType partnerList = this.findFieldType(partnerId).asListType();
        this.updateColumn((Types.NestedField)partnerList.fields().get(0), (Types.NestedField)list.fields().get(0));
        return false;
    }

    public Boolean map(Types.MapType map, Integer partnerId, Boolean isKeyMissing, Boolean isValueMissing) {
        if (partnerId == null) {
            return true;
        }
        Preconditions.checkState((isKeyMissing == false ? 1 : 0) != 0, (Object)"Error traversing schemas: key is missing, but map is present");
        Preconditions.checkState((isValueMissing == false ? 1 : 0) != 0, (Object)"Error traversing schemas: value is missing, but map is present");
        Types.MapType partnerMap = this.findFieldType(partnerId).asMapType();
        this.updateColumn((Types.NestedField)partnerMap.fields().get(0), (Types.NestedField)map.fields().get(0));
        this.updateColumn((Types.NestedField)partnerMap.fields().get(1), (Types.NestedField)map.fields().get(1));
        return false;
    }

    public Boolean primitive(Type.PrimitiveType primitive, Integer partnerId) {
        return partnerId == null;
    }

    private Type findFieldType(int fieldId) {
        if (fieldId == -1) {
            return this.existingSchema.asStruct();
        }
        return this.existingSchema.findField(fieldId).type();
    }

    private void addColumn(int parentId, Types.NestedField field) {
        String parentName = this.existingSchema.findColumnName(parentId);
        this.api.addColumn(parentName, field.name(), field.type(), field.doc());
    }

    private void updateColumn(Types.NestedField existingField, Types.NestedField targetField) {
        boolean needsDocUpdate;
        String existingColumnName = this.existingSchema.findColumnName(existingField.fieldId());
        boolean needsOptionalUpdate = targetField.isOptional() && existingField.isRequired();
        boolean needsTypeUpdate = targetField.type().isPrimitiveType() && !targetField.type().equals(existingField.type());
        boolean bl = needsDocUpdate = targetField.doc() != null && !targetField.doc().equals(existingField.doc());
        if (needsOptionalUpdate) {
            this.api.makeColumnOptional(existingColumnName);
        }
        if (needsTypeUpdate) {
            this.api.updateColumn(existingColumnName, targetField.type().asPrimitiveType());
        }
        if (needsDocUpdate) {
            this.api.updateColumnDoc(existingColumnName, targetField.doc());
        }
    }

    private void setPosition(String columnName, String after) {
        if (after == null) {
            this.api.moveFirst(columnName);
        } else {
            this.api.moveAfter(columnName, after);
        }
    }
}

