/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int maximumSize;
    private final Consumer<Map.Entry<K, V>> evictionCallback;

    LRUCache(int maximumSize) {
        this(maximumSize, ignored -> {});
    }

    LRUCache(int maximumSize, Consumer<Map.Entry<K, V>> evictionCallback) {
        super(Math.min(maximumSize, 16), 0.75f, true);
        this.maximumSize = maximumSize;
        this.evictionCallback = evictionCallback;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean remove;
        boolean bl = remove = this.size() > this.maximumSize;
        if (remove) {
            this.evictionCallback.accept(eldest);
        }
        return remove;
    }
}

