/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.sink.dynamic.CompareSchemasVisitor;
import org.apache.iceberg.flink.sink.dynamic.DataConverter;
import org.apache.iceberg.flink.sink.dynamic.LRUCache;
import org.apache.iceberg.flink.sink.dynamic.PartitionSpecEvolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class TableMetadataCache {
    private static final Logger LOG = LoggerFactory.getLogger(TableMetadataCache.class);
    private static final Tuple2<Boolean, Exception> EXISTS = Tuple2.of((Object)true, null);
    private static final Tuple2<Boolean, Exception> NOT_EXISTS = Tuple2.of((Object)false, null);
    static final ResolvedSchemaInfo NOT_FOUND = new ResolvedSchemaInfo(null, CompareSchemasVisitor.Result.SCHEMA_UPDATE_NEEDED, DataConverter.identity());
    private final Catalog catalog;
    private final long refreshMs;
    private final int inputSchemasPerTableCacheMaximumSize;
    private final Map<TableIdentifier, CacheItem> tableCache;

    TableMetadataCache(Catalog catalog, int maximumSize, long refreshMs, int inputSchemasPerTableCacheMaximumSize) {
        this.catalog = catalog;
        this.refreshMs = refreshMs;
        this.inputSchemasPerTableCacheMaximumSize = inputSchemasPerTableCacheMaximumSize;
        this.tableCache = new LRUCache<TableIdentifier, CacheItem>(maximumSize);
    }

    Tuple2<Boolean, Exception> exists(TableIdentifier identifier) {
        CacheItem cached = this.tableCache.get(identifier);
        if (cached != null && Boolean.TRUE.equals(cached.tableExists)) {
            return EXISTS;
        }
        if (this.needsRefresh(cached, true)) {
            return this.refreshTable(identifier);
        }
        return NOT_EXISTS;
    }

    String branch(TableIdentifier identifier, String branch) {
        return this.branch(identifier, branch, true);
    }

    ResolvedSchemaInfo schema(TableIdentifier identifier, Schema input) {
        return this.schema(identifier, input, true);
    }

    PartitionSpec spec(TableIdentifier identifier, PartitionSpec spec) {
        return this.spec(identifier, spec, true);
    }

    void update(TableIdentifier identifier, Table table) {
        this.tableCache.put(identifier, new CacheItem(true, table.refs().keySet(), table.schemas(), table.specs(), this.inputSchemasPerTableCacheMaximumSize));
    }

    private String branch(TableIdentifier identifier, String branch, boolean allowRefresh) {
        CacheItem cached = this.tableCache.get(identifier);
        if (cached != null && cached.tableExists && cached.branches.contains(branch)) {
            return branch;
        }
        if (this.needsRefresh(cached, allowRefresh)) {
            this.refreshTable(identifier);
            return this.branch(identifier, branch, false);
        }
        return null;
    }

    private ResolvedSchemaInfo schema(TableIdentifier identifier, Schema input, boolean allowRefresh) {
        CacheItem cached = this.tableCache.get(identifier);
        Schema compatible = null;
        if (cached != null && cached.tableExists) {
            ResolvedSchemaInfo lastResult = cached.inputSchemas.get(input);
            if (lastResult != null) {
                return lastResult;
            }
            for (Map.Entry<Integer, Schema> tableSchema : cached.tableSchemas.entrySet()) {
                CompareSchemasVisitor.Result result = CompareSchemasVisitor.visit(input, tableSchema.getValue(), true);
                if (result == CompareSchemasVisitor.Result.SAME) {
                    ResolvedSchemaInfo newResult = new ResolvedSchemaInfo(tableSchema.getValue(), CompareSchemasVisitor.Result.SAME, DataConverter.identity());
                    cached.inputSchemas.put(input, newResult);
                    return newResult;
                }
                if (compatible != null || result != CompareSchemasVisitor.Result.DATA_CONVERSION_NEEDED) continue;
                compatible = tableSchema.getValue();
            }
        }
        if (this.needsRefresh(cached, allowRefresh)) {
            this.refreshTable(identifier);
            return this.schema(identifier, input, false);
        }
        if (compatible != null) {
            ResolvedSchemaInfo newResult = new ResolvedSchemaInfo(compatible, CompareSchemasVisitor.Result.DATA_CONVERSION_NEEDED, DataConverter.get((LogicalType)FlinkSchemaUtil.convert(input), (LogicalType)FlinkSchemaUtil.convert(compatible)));
            cached.inputSchemas.put(input, newResult);
            return newResult;
        }
        if (cached != null && cached.tableExists) {
            cached.inputSchemas.put(input, NOT_FOUND);
            return NOT_FOUND;
        }
        return NOT_FOUND;
    }

    private PartitionSpec spec(TableIdentifier identifier, PartitionSpec spec, boolean allowRefresh) {
        CacheItem cached = this.tableCache.get(identifier);
        if (cached != null && cached.tableExists) {
            for (PartitionSpec tableSpec : cached.specs.values()) {
                if (!PartitionSpecEvolution.checkCompatibility(tableSpec, spec)) continue;
                return tableSpec;
            }
        }
        if (this.needsRefresh(cached, allowRefresh)) {
            this.refreshTable(identifier);
            return this.spec(identifier, spec, false);
        }
        return null;
    }

    private Tuple2<Boolean, Exception> refreshTable(TableIdentifier identifier) {
        try {
            Table table = this.catalog.loadTable(identifier);
            this.update(identifier, table);
            return EXISTS;
        }
        catch (NoSuchTableException e) {
            LOG.debug("Table doesn't exist {}", (Object)identifier, (Object)e);
            this.tableCache.put(identifier, new CacheItem(false, null, null, null, 1));
            return Tuple2.of((Object)false, (Object)((Object)e));
        }
    }

    private boolean needsRefresh(CacheItem cacheItem, boolean allowRefresh) {
        return allowRefresh && (cacheItem == null || cacheItem.created + this.refreshMs > System.currentTimeMillis());
    }

    public void invalidate(TableIdentifier identifier) {
        this.tableCache.remove(identifier);
    }

    @VisibleForTesting
    Map<TableIdentifier, CacheItem> getInternalCache() {
        return this.tableCache;
    }

    static class CacheItem {
        private final long created = System.currentTimeMillis();
        private final boolean tableExists;
        private final Set<String> branches;
        private final Map<Integer, Schema> tableSchemas;
        private final Map<Integer, PartitionSpec> specs;
        private final Map<Schema, ResolvedSchemaInfo> inputSchemas;

        private CacheItem(boolean tableExists, Set<String> branches, Map<Integer, Schema> tableSchemas, Map<Integer, PartitionSpec> specs, int inputSchemaCacheMaximumSize) {
            this.tableExists = tableExists;
            this.branches = branches;
            this.tableSchemas = tableSchemas;
            this.specs = specs;
            this.inputSchemas = new LRUCache<Schema, ResolvedSchemaInfo>(inputSchemaCacheMaximumSize, CacheItem::inputSchemaEvictionListener);
        }

        private static void inputSchemaEvictionListener(Map.Entry<Schema, ResolvedSchemaInfo> evictedEntry) {
            LOG.warn("Performance degraded as records with different schema is generated for the same table. Likely the DynamicRecord.schema is not reused. Reuse the same instance if the record schema is the same to improve performance");
        }

        @VisibleForTesting
        Map<Schema, ResolvedSchemaInfo> inputSchemas() {
            return this.inputSchemas;
        }
    }

    static class ResolvedSchemaInfo {
        private final Schema resolvedTableSchema;
        private final CompareSchemasVisitor.Result compareResult;
        private final DataConverter recordConverter;

        ResolvedSchemaInfo(Schema tableSchema, CompareSchemasVisitor.Result compareResult, DataConverter recordConverter) {
            this.resolvedTableSchema = tableSchema;
            this.compareResult = compareResult;
            this.recordConverter = recordConverter;
        }

        Schema resolvedTableSchema() {
            return this.resolvedTableSchema;
        }

        CompareSchemasVisitor.Result compareResult() {
            return this.compareResult;
        }

        DataConverter recordConverter() {
            return this.recordConverter;
        }
    }
}

