/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.hadoop.util.Sets;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class WriteTarget
implements Serializable {
    private final String tableName;
    private final String branch;
    private final Integer schemaId;
    private final Integer specId;
    private final boolean upsertMode;
    private final Set<Integer> equalityFields;

    WriteTarget(String tableName, String branch, Integer schemaId, Integer specId, boolean upsertMode, Set<Integer> equalityFields) {
        this.tableName = tableName;
        this.branch = branch != null ? branch : "main";
        this.schemaId = schemaId;
        this.specId = specId;
        this.upsertMode = upsertMode;
        this.equalityFields = equalityFields;
    }

    String tableName() {
        return this.tableName;
    }

    String branch() {
        return this.branch;
    }

    Integer schemaId() {
        return this.schemaId;
    }

    Integer specId() {
        return this.specId;
    }

    boolean upsertMode() {
        return this.upsertMode;
    }

    Set<Integer> equalityFields() {
        return this.equalityFields;
    }

    void serializeTo(DataOutputView view) throws IOException {
        view.writeUTF(this.tableName);
        view.writeUTF(this.branch);
        view.writeInt(this.schemaId.intValue());
        view.writeInt(this.specId.intValue());
        view.writeBoolean(this.upsertMode);
        view.writeInt(this.equalityFields.size());
        for (Integer equalityField : this.equalityFields) {
            view.writeInt(equalityField.intValue());
        }
    }

    static WriteTarget deserializeFrom(DataInputView view) throws IOException {
        return new WriteTarget(view.readUTF(), view.readUTF(), view.readInt(), view.readInt(), view.readBoolean(), WriteTarget.readSet(view));
    }

    private static Set<Integer> readSet(DataInputView view) throws IOException {
        int numFields = view.readInt();
        HashSet equalityFields = Sets.newHashSetWithExpectedSize((int)numFields);
        for (int i = 0; i < numFields; ++i) {
            equalityFields.add(view.readInt());
        }
        return equalityFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WriteTarget that = (WriteTarget)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.branch, that.branch) && Objects.equals(this.schemaId, that.schemaId) && Objects.equals(this.specId, that.specId) && this.upsertMode == that.upsertMode && Objects.equals(this.equalityFields, that.equalityFields);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.branch, this.schemaId, this.specId, this.upsertMode, this.equalityFields);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("branch", (Object)this.branch).add("schemaId", (Object)this.schemaId).add("specId", (Object)this.specId).add("upsertMode", this.upsertMode).toString();
    }
}

