/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.CompletedStatistics;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;

class CompletedStatisticsSerializer
extends TypeSerializer<CompletedStatistics> {
    private final TypeSerializer<SortKey> sortKeySerializer;
    private final EnumSerializer<StatisticsType> statisticsTypeSerializer;
    private final MapSerializer<SortKey, Long> keyFrequencySerializer;
    private final ListSerializer<SortKey> keySamplesSerializer;

    CompletedStatisticsSerializer(TypeSerializer<SortKey> sortKeySerializer) {
        this.sortKeySerializer = sortKeySerializer;
        this.statisticsTypeSerializer = new EnumSerializer(StatisticsType.class);
        this.keyFrequencySerializer = new MapSerializer(sortKeySerializer, (TypeSerializer)LongSerializer.INSTANCE);
        this.keySamplesSerializer = new ListSerializer(sortKeySerializer);
    }

    public void changeSortKeySerializerVersion(int version) {
        if (this.sortKeySerializer instanceof SortKeySerializer) {
            ((SortKeySerializer)this.sortKeySerializer).setVersion(version);
        }
    }

    public void changeSortKeySerializerVersionLatest() {
        if (this.sortKeySerializer instanceof SortKeySerializer) {
            ((SortKeySerializer)this.sortKeySerializer).restoreToLatestVersion();
        }
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<CompletedStatistics> duplicate() {
        return new CompletedStatisticsSerializer(this.sortKeySerializer);
    }

    public CompletedStatistics createInstance() {
        return CompletedStatistics.fromKeyFrequency(0L, Collections.emptyMap());
    }

    public CompletedStatistics copy(CompletedStatistics from) {
        return new CompletedStatistics(from.checkpointId(), from.type(), from.keyFrequency(), from.keySamples());
    }

    public CompletedStatistics copy(CompletedStatistics from, CompletedStatistics reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(CompletedStatistics record, DataOutputView target) throws IOException {
        target.writeLong(record.checkpointId());
        this.statisticsTypeSerializer.serialize((Enum)record.type(), target);
        if (record.type() == StatisticsType.Map) {
            this.keyFrequencySerializer.serialize(record.keyFrequency(), target);
        } else {
            this.keySamplesSerializer.serialize(Arrays.asList(record.keySamples()), target);
        }
    }

    public CompletedStatistics deserialize(DataInputView source) throws IOException {
        long checkpointId = source.readLong();
        StatisticsType type = (StatisticsType)this.statisticsTypeSerializer.deserialize(source);
        if (type == StatisticsType.Map) {
            Map keyFrequency = this.keyFrequencySerializer.deserialize(source);
            return CompletedStatistics.fromKeyFrequency(checkpointId, keyFrequency);
        }
        List sortKeys = this.keySamplesSerializer.deserialize(source);
        SortKey[] keySamples = new SortKey[sortKeys.size()];
        keySamples = sortKeys.toArray(keySamples);
        return CompletedStatistics.fromKeySamples(checkpointId, keySamples);
    }

    public CompletedStatistics deserialize(CompletedStatistics reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CompletedStatisticsSerializer other = (CompletedStatisticsSerializer)((Object)obj);
        return Objects.equals(this.sortKeySerializer, other.sortKeySerializer);
    }

    public int hashCode() {
        return this.sortKeySerializer.hashCode();
    }

    public TypeSerializerSnapshot<CompletedStatistics> snapshotConfiguration() {
        return new CompletedStatisticsSerializerSnapshot(this);
    }

    public static class CompletedStatisticsSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<CompletedStatistics, CompletedStatisticsSerializer> {
        private static final int CURRENT_VERSION = 1;

        public CompletedStatisticsSerializerSnapshot() {
        }

        public CompletedStatisticsSerializerSnapshot(CompletedStatisticsSerializer serializer) {
            super((TypeSerializer)serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(CompletedStatisticsSerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.sortKeySerializer};
        }

        protected CompletedStatisticsSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            SortKeySerializer sortKeySerializer = (SortKeySerializer)nestedSerializers[0];
            return new CompletedStatisticsSerializer(sortKeySerializer);
        }
    }
}

