/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.flink.sink.shuffle.CompletedStatistics;
import org.apache.iceberg.flink.sink.shuffle.CompletedStatisticsSerializer;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.GlobalStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.SketchDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.SketchUtil;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;

class StatisticsUtil {
    private StatisticsUtil() {
    }

    static DataStatistics createTaskStatistics(StatisticsType type, int operatorParallelism, int numPartitions) {
        if (type == StatisticsType.Map) {
            return new MapDataStatistics();
        }
        return new SketchDataStatistics(SketchUtil.determineOperatorReservoirSize(operatorParallelism, numPartitions));
    }

    static byte[] serializeDataStatistics(DataStatistics dataStatistics, TypeSerializer<DataStatistics> statisticsSerializer) {
        DataOutputSerializer out = new DataOutputSerializer(64);
        try {
            statisticsSerializer.serialize((Object)dataStatistics, (DataOutputView)out);
            return out.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to serialize data statistics", e);
        }
    }

    static DataStatistics deserializeDataStatistics(byte[] bytes, TypeSerializer<DataStatistics> statisticsSerializer) {
        DataInputDeserializer input = new DataInputDeserializer(bytes, 0, bytes.length);
        try {
            return (DataStatistics)statisticsSerializer.deserialize((DataInputView)input);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to deserialize data statistics", e);
        }
    }

    static byte[] serializeCompletedStatistics(CompletedStatistics completedStatistics, TypeSerializer<CompletedStatistics> statisticsSerializer) {
        try {
            DataOutputSerializer out = new DataOutputSerializer(1024);
            statisticsSerializer.serialize((Object)completedStatistics, (DataOutputView)out);
            return out.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to serialize aggregated statistics", e);
        }
    }

    static CompletedStatistics deserializeCompletedStatistics(byte[] bytes, CompletedStatisticsSerializer statisticsSerializer) {
        try {
            DataInputDeserializer input = new DataInputDeserializer(bytes);
            CompletedStatistics completedStatistics = statisticsSerializer.deserialize((DataInputView)input);
            if (!completedStatistics.isValid()) {
                throw new RuntimeException("Fail to deserialize aggregated statistics,change to v1");
            }
            return completedStatistics;
        }
        catch (Exception e) {
            try {
                statisticsSerializer.changeSortKeySerializerVersion(1);
                DataInputDeserializer input = new DataInputDeserializer(bytes);
                CompletedStatistics deserialize = statisticsSerializer.deserialize((DataInputView)input);
                statisticsSerializer.changeSortKeySerializerVersionLatest();
                return deserialize;
            }
            catch (IOException ioException) {
                throw new UncheckedIOException("Fail to deserialize aggregated statistics", ioException);
            }
        }
    }

    static byte[] serializeGlobalStatistics(GlobalStatistics globalStatistics, TypeSerializer<GlobalStatistics> statisticsSerializer) {
        try {
            DataOutputSerializer out = new DataOutputSerializer(1024);
            statisticsSerializer.serialize((Object)globalStatistics, (DataOutputView)out);
            return out.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to serialize aggregated statistics", e);
        }
    }

    static GlobalStatistics deserializeGlobalStatistics(byte[] bytes, TypeSerializer<GlobalStatistics> statisticsSerializer) {
        try {
            DataInputDeserializer input = new DataInputDeserializer(bytes);
            return (GlobalStatistics)statisticsSerializer.deserialize((DataInputView)input);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to deserialize aggregated statistics", e);
        }
    }

    static StatisticsType collectType(StatisticsType config) {
        return config == StatisticsType.Sketch ? StatisticsType.Sketch : StatisticsType.Map;
    }

    static StatisticsType collectType(StatisticsType config, @Nullable GlobalStatistics statistics) {
        if (statistics != null) {
            return statistics.type();
        }
        return StatisticsUtil.collectType(config);
    }

    static StatisticsType collectType(StatisticsType config, @Nullable CompletedStatistics statistics) {
        if (statistics != null) {
            return statistics.type();
        }
        return StatisticsUtil.collectType(config);
    }
}

