/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.flink.source.reader.RecordLimiter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class LimitableDataIterator<T>
extends DataIterator<T> {
    private final RecordLimiter limiter;

    LimitableDataIterator(FileScanTaskReader<T> fileScanTaskReader, CombinedScanTask task, FileIO io, EncryptionManager encryption, RecordLimiter limiter) {
        super(fileScanTaskReader, task, io, encryption);
        Preconditions.checkArgument((limiter != null ? 1 : 0) != 0, (Object)"Invalid record limiter: null");
        this.limiter = limiter;
    }

    @Override
    public boolean hasNext() {
        if (this.limiter.reachedLimit()) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public T next() {
        this.limiter.increment();
        return super.next();
    }
}

