/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;

class SerializerHelper
implements Serializable {
    private SerializerHelper() {
    }

    public static void writeLongUTF(DataOutputSerializer out, String str) throws IOException {
        int strlen = str.length();
        long utflen = 0L;
        for (int i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            if ((utflen += (long)SerializerHelper.getUTFBytesSize(ch)) <= Integer.MAX_VALUE) continue;
            throw new UTFDataFormatException("Encoded string reached maximum length: " + utflen);
        }
        if (utflen > 0x7FFFFFFBL) {
            throw new UTFDataFormatException("Encoded string is too long: " + utflen);
        }
        out.writeInt((int)utflen);
        SerializerHelper.writeUTFBytes(out, str, (int)utflen);
    }

    public static String readLongUTF(DataInputDeserializer in) throws IOException {
        int ch;
        int count;
        int utflen = in.readInt();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararrCount = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (ch = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)ch;
        }
        block6: while (count < utflen) {
            ch = bytearr[count] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)ch;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((ch & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }

    private static int getUTFBytesSize(int ch) {
        if (ch >= 1 && ch <= 127) {
            return 1;
        }
        if (ch > 2047) {
            return 3;
        }
        return 2;
    }

    private static void writeUTFBytes(DataOutputSerializer out, String str, int utflen) throws IOException {
        char ch;
        int index;
        int strlen = str.length();
        int len = Math.max(1024, utflen);
        byte[] bytearr = new byte[len];
        int count = 0;
        for (index = 0; index < strlen && (ch = str.charAt(index)) >= '\u0001' && ch <= '\u007f'; ++index) {
            bytearr[count++] = (byte)ch;
        }
        while (index < strlen) {
            ch = str.charAt(index);
            if (ch >= '\u0001' && ch <= '\u007f') {
                bytearr[count++] = (byte)ch;
            } else if (ch > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | ch >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | ch >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | ch & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | ch >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | ch & 0x3F);
            }
            ++index;
        }
        out.write(bytearr, 0, count);
    }
}

