/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkFixupTypes;
import org.apache.iceberg.flink.FlinkTypeToType;
import org.apache.iceberg.flink.TypeToFlinkType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class FlinkSchemaUtil {
    private FlinkSchemaUtil() {
    }

    @Deprecated
    public static Schema convert(TableSchema schema) {
        LogicalType schemaType = schema.toRowDataType().getLogicalType();
        Preconditions.checkArgument((boolean)(schemaType instanceof RowType), (Object)"Schema logical type should be row type.");
        RowType root = (RowType)schemaType;
        Type converted = (Type)root.accept((LogicalTypeVisitor)new FlinkTypeToType(root));
        Schema icebergSchema = new Schema(converted.asStructType().fields());
        if (schema.getPrimaryKey().isPresent()) {
            return FlinkSchemaUtil.freshIdentifierFieldIds(icebergSchema, ((org.apache.flink.table.api.constraints.UniqueConstraint)schema.getPrimaryKey().get()).getColumns());
        }
        return icebergSchema;
    }

    public static Schema convert(ResolvedSchema flinkSchema) {
        List tableColumns = flinkSchema.getColumns();
        DataTypes.Field[] fields = (DataTypes.Field[])tableColumns.stream().map(column -> {
            if (column.getComment().isPresent()) {
                return DataTypes.FIELD((String)column.getName(), (DataType)column.getDataType(), (String)((String)column.getComment().get()));
            }
            return DataTypes.FIELD((String)column.getName(), (DataType)column.getDataType());
        }).toArray(DataTypes.Field[]::new);
        LogicalType schemaType = ((DataType)DataTypes.ROW((DataTypes.Field[])fields).notNull()).getLogicalType();
        Preconditions.checkArgument((boolean)(schemaType instanceof RowType), (Object)"Schema logical type should be row type.");
        RowType root = (RowType)schemaType;
        Type converted = (Type)root.accept((LogicalTypeVisitor)new FlinkTypeToType(root));
        Schema icebergSchema = new Schema(converted.asStructType().fields());
        if (flinkSchema.getPrimaryKey().isPresent()) {
            return FlinkSchemaUtil.freshIdentifierFieldIds(icebergSchema, ((UniqueConstraint)flinkSchema.getPrimaryKey().get()).getColumns());
        }
        return icebergSchema;
    }

    private static Schema freshIdentifierFieldIds(Schema icebergSchema, List<String> primaryKeys) {
        HashSet identifierFieldIds = Sets.newHashSet();
        for (String primaryKey : primaryKeys) {
            Types.NestedField field = icebergSchema.findField(primaryKey);
            Preconditions.checkNotNull((Object)field, (String)"Cannot find field ID for the primary key column %s in schema %s", (Object)primaryKey, (Object)icebergSchema);
            identifierFieldIds.add(field.fieldId());
        }
        return new Schema(icebergSchema.schemaId(), icebergSchema.asStruct().fields(), (Set)identifierFieldIds);
    }

    public static Schema convert(Schema baseSchema, TableSchema flinkSchema) {
        Types.StructType struct = FlinkSchemaUtil.convert(flinkSchema).asStruct();
        Schema schema = TypeUtil.reassignIds((Schema)new Schema(struct.fields()), (Schema)baseSchema);
        schema = TypeUtil.reassignDoc((Schema)schema, (Schema)baseSchema);
        Schema fixedSchema = FlinkFixupTypes.fixup(schema, baseSchema);
        if (flinkSchema.getPrimaryKey().isPresent()) {
            return FlinkSchemaUtil.freshIdentifierFieldIds(fixedSchema, ((org.apache.flink.table.api.constraints.UniqueConstraint)flinkSchema.getPrimaryKey().get()).getColumns());
        }
        return fixedSchema;
    }

    public static RowType convert(Schema schema) {
        return (RowType)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeToFlinkType());
    }

    public static LogicalType convert(Type type) {
        return (LogicalType)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToFlinkType());
    }

    public static Type convert(LogicalType flinkType) {
        return (Type)flinkType.accept((LogicalTypeVisitor)new FlinkTypeToType());
    }

    public static TableSchema toSchema(RowType rowType) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : rowType.getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        return builder.build();
    }

    public static TableSchema toSchema(Schema schema) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : FlinkSchemaUtil.convert(schema).getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        Set identifierFieldIds = schema.identifierFieldIds();
        if (!identifierFieldIds.isEmpty()) {
            ArrayList columns = Lists.newArrayListWithExpectedSize((int)identifierFieldIds.size());
            for (Integer identifierFieldId : identifierFieldIds) {
                String columnName = schema.findColumnName(identifierFieldId.intValue());
                Preconditions.checkNotNull((Object)columnName, (String)"Cannot find field with id %s in schema %s", (Object)identifierFieldId, (Object)schema);
                columns.add(columnName);
            }
            builder.primaryKey(columns.toArray(new String[0]));
        }
        return builder.build();
    }
}

