/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.iceberg.flink.FlinkTypeVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class FlinkTypeToType
extends FlinkTypeVisitor<Type> {
    private final RowType root;
    private int nextId;

    FlinkTypeToType() {
        this.root = null;
    }

    FlinkTypeToType(RowType root) {
        this.root = root;
        this.nextId = root.getFieldCount();
    }

    private int getNextId() {
        int next = this.nextId++;
        return next;
    }

    public Type visit(CharType charType) {
        return Types.StringType.get();
    }

    public Type visit(VarCharType varCharType) {
        return Types.StringType.get();
    }

    public Type visit(BooleanType booleanType) {
        return Types.BooleanType.get();
    }

    public Type visit(BinaryType binaryType) {
        return Types.FixedType.ofLength((int)binaryType.getLength());
    }

    public Type visit(VarBinaryType varBinaryType) {
        return Types.BinaryType.get();
    }

    public Type visit(DecimalType decimalType) {
        return Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale());
    }

    public Type visit(TinyIntType tinyIntType) {
        return Types.IntegerType.get();
    }

    public Type visit(SmallIntType smallIntType) {
        return Types.IntegerType.get();
    }

    public Type visit(IntType intType) {
        return Types.IntegerType.get();
    }

    public Type visit(BigIntType bigIntType) {
        return Types.LongType.get();
    }

    public Type visit(FloatType floatType) {
        return Types.FloatType.get();
    }

    public Type visit(DoubleType doubleType) {
        return Types.DoubleType.get();
    }

    public Type visit(DateType dateType) {
        return Types.DateType.get();
    }

    public Type visit(TimeType timeType) {
        return Types.TimeType.get();
    }

    public Type visit(TimestampType timestampType) {
        return Types.TimestampType.withoutZone();
    }

    public Type visit(LocalZonedTimestampType localZonedTimestampType) {
        return Types.TimestampType.withZone();
    }

    public Type visit(ArrayType arrayType) {
        Type elementType = (Type)arrayType.getElementType().accept((LogicalTypeVisitor)this);
        if (arrayType.getElementType().isNullable()) {
            return Types.ListType.ofOptional((int)this.getNextId(), (Type)elementType);
        }
        return Types.ListType.ofRequired((int)this.getNextId(), (Type)elementType);
    }

    public Type visit(MultisetType multisetType) {
        Type elementType = (Type)multisetType.getElementType().accept((LogicalTypeVisitor)this);
        return Types.MapType.ofRequired((int)this.getNextId(), (int)this.getNextId(), (Type)elementType, (Type)Types.IntegerType.get());
    }

    public Type visit(MapType mapType) {
        Type keyType = (Type)mapType.getKeyType().accept((LogicalTypeVisitor)this);
        Type valueType = (Type)mapType.getValueType().accept((LogicalTypeVisitor)this);
        if (mapType.getValueType().isNullable()) {
            return Types.MapType.ofOptional((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
        }
        return Types.MapType.ofRequired((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
    }

    public Type visit(RowType rowType) {
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)rowType.getFieldCount());
        boolean isRoot = this.root == rowType;
        List types = rowType.getFields().stream().map(f -> (Type)f.getType().accept((LogicalTypeVisitor)this)).collect(Collectors.toList());
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            int id = isRoot ? i : this.getNextId();
            RowType.RowField field = (RowType.RowField)rowType.getFields().get(i);
            String name = field.getName();
            String comment = field.getDescription().orElse(null);
            if (field.getType().isNullable()) {
                newFields.add(Types.NestedField.optional((int)id, (String)name, (Type)((Type)types.get(i)), (String)comment));
                continue;
            }
            newFields.add(Types.NestedField.required((int)id, (String)name, (Type)((Type)types.get(i)), (String)comment));
        }
        return Types.StructType.of((List)newFields);
    }
}

