/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.sink.BucketPartitionerUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class BucketPartitioner
implements Partitioner<Integer> {
    static final String BUCKET_NULL_MESSAGE = "bucketId cannot be null";
    static final String BUCKET_LESS_THAN_LOWER_BOUND_MESSAGE = "Invalid bucket ID %s: must be non-negative.";
    static final String BUCKET_GREATER_THAN_UPPER_BOUND_MESSAGE = "Invalid bucket ID %s: must be less than bucket limit: %s.";
    private final int maxNumBuckets;
    private final int[] currentBucketWriterOffset;

    BucketPartitioner(PartitionSpec partitionSpec) {
        this.maxNumBuckets = BucketPartitionerUtil.getMaxNumBuckets(partitionSpec);
        this.currentBucketWriterOffset = new int[this.maxNumBuckets];
    }

    public int partition(Integer bucketId, int numPartitions) {
        Preconditions.checkNotNull((Object)bucketId, (Object)BUCKET_NULL_MESSAGE);
        Preconditions.checkArgument((bucketId >= 0 ? 1 : 0) != 0, (String)BUCKET_LESS_THAN_LOWER_BOUND_MESSAGE, (Object)bucketId);
        Preconditions.checkArgument((bucketId < this.maxNumBuckets ? 1 : 0) != 0, (String)BUCKET_GREATER_THAN_UPPER_BOUND_MESSAGE, (Object)bucketId, (int)this.maxNumBuckets);
        if (numPartitions <= this.maxNumBuckets) {
            return bucketId % numPartitions;
        }
        return this.getPartitionWithMoreWritersThanBuckets(bucketId, numPartitions);
    }

    private int getPartitionWithMoreWritersThanBuckets(int bucketId, int numPartitions) {
        int nextOffset;
        int currentOffset = this.currentBucketWriterOffset[bucketId];
        int extraWriter = bucketId < numPartitions % this.maxNumBuckets ? 1 : 0;
        int maxNumWritersPerBucket = numPartitions / this.maxNumBuckets + extraWriter;
        this.currentBucketWriterOffset[bucketId] = nextOffset = currentOffset == maxNumWritersPerBucket - 1 ? 0 : currentOffset + 1;
        return bucketId + this.maxNumBuckets * currentOffset;
    }
}

