/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class IcebergCommittable
implements Serializable {
    private final byte[] manifest;
    private final String jobId;
    private final String operatorId;
    private final long checkpointId;

    IcebergCommittable(byte[] manifest, String jobId, String operatorId, long checkpointId) {
        this.manifest = manifest;
        this.jobId = jobId;
        this.operatorId = operatorId;
        this.checkpointId = checkpointId;
    }

    byte[] manifest() {
        return this.manifest;
    }

    String jobId() {
        return this.jobId;
    }

    String operatorId() {
        return this.operatorId;
    }

    Long checkpointId() {
        return this.checkpointId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobId", (Object)this.jobId).add("checkpointId", this.checkpointId).add("operatorId", (Object)this.operatorId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergCommittable that = (IcebergCommittable)o;
        return this.checkpointId == that.checkpointId && Arrays.equals(this.manifest, that.manifest) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.operatorId, that.operatorId);
    }

    public int hashCode() {
        int result = Objects.hash(this.jobId, this.operatorId, this.checkpointId);
        result = 31 * result + Arrays.hashCode(this.manifest);
        return result;
    }
}

