/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.connector.sink2.CommittingSinkWriter;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.flink.sink.IcebergStreamWriterMetrics;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IcebergSinkWriter
implements CommittingSinkWriter<RowData, WriteResult> {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergSinkWriter.class);
    private final String fullTableName;
    private final TaskWriterFactory<RowData> taskWriterFactory;
    private final IcebergStreamWriterMetrics metrics;
    private TaskWriter<RowData> writer;
    private final int subTaskId;
    private final int attemptId;

    IcebergSinkWriter(String fullTableName, TaskWriterFactory<RowData> taskWriterFactory, IcebergStreamWriterMetrics metrics, int subTaskId, int attemptId) {
        this.fullTableName = fullTableName;
        this.taskWriterFactory = taskWriterFactory;
        taskWriterFactory.initialize(subTaskId, attemptId);
        this.writer = taskWriterFactory.create();
        this.metrics = metrics;
        this.subTaskId = subTaskId;
        this.attemptId = attemptId;
        LOG.debug("Created Stream Writer for table {} subtask {} attemptId {}", new Object[]{fullTableName, subTaskId, attemptId});
    }

    public void write(RowData element, SinkWriter.Context context) throws IOException, InterruptedException {
        this.writer.write((Object)element);
    }

    public void flush(boolean endOfInput) {
    }

    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.fullTableName).add("subTaskId", this.subTaskId).add("attemptId", this.attemptId).toString();
    }

    public Collection<WriteResult> prepareCommit() throws IOException {
        long startNano = System.nanoTime();
        WriteResult result = this.writer.complete();
        this.writer = this.taskWriterFactory.create();
        this.metrics.updateFlushResult(result);
        this.metrics.flushDuration(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNano));
        LOG.debug("Iceberg writer subtask {} attempt {} flushed {} data files and {} delete files", new Object[]{this.subTaskId, this.attemptId, result.dataFiles().length, result.deleteFiles().length});
        return Lists.newArrayList((Object[])new WriteResult[]{result});
    }
}

