/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.sink.CachingTableSupplier;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.flink.sink.PartitionedDeltaWriter;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.flink.sink.UnpartitionedDeltaWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedFanoutWriter;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.SerializableSupplier;

public class RowDataTaskWriterFactory
implements TaskWriterFactory<RowData> {
    private final Supplier<Table> tableSupplier;
    private final Schema schema;
    private final RowType flinkSchema;
    private final PartitionSpec spec;
    private final long targetFileSizeBytes;
    private final FileFormat format;
    private final List<Integer> equalityFieldIds;
    private final boolean upsert;
    private final FileAppenderFactory<RowData> appenderFactory;
    private transient OutputFileFactory outputFileFactory;

    public RowDataTaskWriterFactory(Table table, RowType flinkSchema, long targetFileSizeBytes, FileFormat format, Map<String, String> writeProperties, List<Integer> equalityFieldIds, boolean upsert) {
        this((SerializableSupplier<Table>)(SerializableSupplier & Serializable)() -> table, flinkSchema, targetFileSizeBytes, format, writeProperties, equalityFieldIds, upsert);
    }

    public RowDataTaskWriterFactory(SerializableSupplier<Table> tableSupplier, RowType flinkSchema, long targetFileSizeBytes, FileFormat format, Map<String, String> writeProperties, List<Integer> equalityFieldIds, boolean upsert) {
        this.tableSupplier = tableSupplier;
        Table table = tableSupplier instanceof CachingTableSupplier ? ((CachingTableSupplier)tableSupplier).initialTable() : (Table)tableSupplier.get();
        this.schema = table.schema();
        this.flinkSchema = flinkSchema;
        this.spec = table.spec();
        this.targetFileSizeBytes = targetFileSizeBytes;
        this.format = format;
        this.equalityFieldIds = equalityFieldIds;
        this.upsert = upsert;
        this.appenderFactory = equalityFieldIds == null || equalityFieldIds.isEmpty() ? new FlinkAppenderFactory(table, this.schema, flinkSchema, writeProperties, this.spec, null, null, null) : (upsert ? new FlinkAppenderFactory(table, this.schema, flinkSchema, writeProperties, this.spec, ArrayUtil.toIntArray(equalityFieldIds), TypeUtil.select((Schema)this.schema, (Set)Sets.newHashSet(equalityFieldIds)), null) : new FlinkAppenderFactory(table, this.schema, flinkSchema, writeProperties, this.spec, ArrayUtil.toIntArray(equalityFieldIds), this.schema, null));
    }

    @Override
    public void initialize(int taskId, int attemptId) {
        Table table = this.tableSupplier instanceof CachingTableSupplier ? ((CachingTableSupplier)((Object)this.tableSupplier)).initialTable() : this.tableSupplier.get();
        this.refreshTable();
        this.outputFileFactory = OutputFileFactory.builderFor((Table)table, (int)taskId, (long)attemptId).format(this.format).ioSupplier(() -> this.tableSupplier.get().io()).build();
    }

    @Override
    public TaskWriter<RowData> create() {
        Preconditions.checkNotNull((Object)this.outputFileFactory, (Object)"The outputFileFactory shouldn't be null if we have invoked the initialize().");
        this.refreshTable();
        if (this.equalityFieldIds == null || this.equalityFieldIds.isEmpty()) {
            if (this.spec.isUnpartitioned()) {
                return new UnpartitionedWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.tableSupplier.get().io(), this.targetFileSizeBytes);
            }
            return new RowDataPartitionedFanoutWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.tableSupplier.get().io(), this.targetFileSizeBytes, this.schema, this.flinkSchema);
        }
        if (this.spec.isUnpartitioned()) {
            return new UnpartitionedDeltaWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.tableSupplier.get().io(), this.targetFileSizeBytes, this.schema, this.flinkSchema, this.equalityFieldIds, this.upsert);
        }
        return new PartitionedDeltaWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.tableSupplier.get().io(), this.targetFileSizeBytes, this.schema, this.flinkSchema, this.equalityFieldIds, this.upsert);
    }

    void refreshTable() {
        if (this.tableSupplier instanceof CachingTableSupplier) {
            ((CachingTableSupplier)((Object)this.tableSupplier)).refreshTable();
        }
    }

    private static class RowDataPartitionedFanoutWriter
    extends PartitionedFanoutWriter<RowData> {
        private final PartitionKey partitionKey;
        private final RowDataWrapper rowDataWrapper;

        RowDataPartitionedFanoutWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<RowData> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, RowType flinkSchema) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
            this.partitionKey = new PartitionKey(spec, schema);
            this.rowDataWrapper = new RowDataWrapper(flinkSchema, schema.asStruct());
        }

        protected PartitionKey partition(RowData row) {
            this.partitionKey.partition((StructLike)this.rowDataWrapper.wrap(row));
            return this.partitionKey;
        }
    }
}

