/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Arrays;
import java.util.Map;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;

class CompletedStatistics {
    private final long checkpointId;
    private final StatisticsType type;
    private final Map<SortKey, Long> keyFrequency;
    private final SortKey[] keySamples;

    static CompletedStatistics fromKeyFrequency(long checkpointId, Map<SortKey, Long> stats) {
        return new CompletedStatistics(checkpointId, StatisticsType.Map, stats, null);
    }

    static CompletedStatistics fromKeySamples(long checkpointId, SortKey[] keySamples) {
        return new CompletedStatistics(checkpointId, StatisticsType.Sketch, null, keySamples);
    }

    CompletedStatistics(long checkpointId, StatisticsType type, Map<SortKey, Long> keyFrequency, SortKey[] keySamples) {
        this.checkpointId = checkpointId;
        this.type = type;
        this.keyFrequency = keyFrequency;
        this.keySamples = keySamples;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("checkpointId", this.checkpointId).add("type", (Object)this.type).add("keyFrequency", this.keyFrequency).add("keySamples", (Object)this.keySamples).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompletedStatistics)) {
            return false;
        }
        CompletedStatistics other = (CompletedStatistics)o;
        return Objects.equal((Object)this.checkpointId, (Object)other.checkpointId) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal(this.keyFrequency, other.keyFrequency()) && Arrays.equals(this.keySamples, other.keySamples());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.checkpointId, this.type, this.keyFrequency, this.keySamples});
    }

    long checkpointId() {
        return this.checkpointId;
    }

    StatisticsType type() {
        return this.type;
    }

    Map<SortKey, Long> keyFrequency() {
        return this.keyFrequency;
    }

    SortKey[] keySamples() {
        return this.keySamples;
    }

    boolean isEmpty() {
        if (this.type == StatisticsType.Sketch) {
            return this.keySamples.length == 0;
        }
        return this.keyFrequency().isEmpty();
    }

    boolean isValid() {
        if (this.type == StatisticsType.Sketch) {
            if (null == this.keySamples) {
                return false;
            }
        } else {
            if (null == this.keyFrequency()) {
                return false;
            }
            if (this.keyFrequency().values().contains(null)) {
                return false;
            }
        }
        return true;
    }
}

