/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.GlobalStatistics;
import org.apache.iceberg.flink.sink.shuffle.KeyAssignment;
import org.apache.iceberg.flink.sink.shuffle.MapAssignment;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

class GlobalStatisticsSerializer
extends TypeSerializer<GlobalStatistics> {
    private final TypeSerializer<SortKey> sortKeySerializer;
    private final EnumSerializer<StatisticsType> statisticsTypeSerializer;
    private final ListSerializer<SortKey> rangeBoundsSerializer;
    private final ListSerializer<Integer> intsSerializer;
    private final ListSerializer<Long> longsSerializer;

    GlobalStatisticsSerializer(TypeSerializer<SortKey> sortKeySerializer) {
        this.sortKeySerializer = sortKeySerializer;
        this.statisticsTypeSerializer = new EnumSerializer(StatisticsType.class);
        this.rangeBoundsSerializer = new ListSerializer(sortKeySerializer);
        this.intsSerializer = new ListSerializer((TypeSerializer)IntSerializer.INSTANCE);
        this.longsSerializer = new ListSerializer((TypeSerializer)LongSerializer.INSTANCE);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<GlobalStatistics> duplicate() {
        return new GlobalStatisticsSerializer(this.sortKeySerializer);
    }

    public GlobalStatistics createInstance() {
        return GlobalStatistics.fromRangeBounds(0L, new SortKey[0]);
    }

    public GlobalStatistics copy(GlobalStatistics from) {
        return new GlobalStatistics(from.checkpointId(), from.type(), from.mapAssignment(), from.rangeBounds());
    }

    public GlobalStatistics copy(GlobalStatistics from, GlobalStatistics reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(GlobalStatistics record, DataOutputView target) throws IOException {
        target.writeLong(record.checkpointId());
        this.statisticsTypeSerializer.serialize((Enum)record.type(), target);
        if (record.type() == StatisticsType.Map) {
            MapAssignment mapAssignment = record.mapAssignment();
            target.writeInt(mapAssignment.numPartitions());
            target.writeInt(mapAssignment.keyAssignments().size());
            for (Map.Entry<SortKey, KeyAssignment> entry : mapAssignment.keyAssignments().entrySet()) {
                this.sortKeySerializer.serialize((Object)entry.getKey(), target);
                KeyAssignment keyAssignment = entry.getValue();
                this.intsSerializer.serialize(keyAssignment.assignedSubtasks(), target);
                this.longsSerializer.serialize(keyAssignment.subtaskWeightsWithCloseFileCost(), target);
                target.writeLong(keyAssignment.closeFileCostWeight());
            }
        } else {
            this.rangeBoundsSerializer.serialize(Arrays.asList(record.rangeBounds()), target);
        }
    }

    public GlobalStatistics deserialize(DataInputView source) throws IOException {
        long checkpointId = source.readLong();
        StatisticsType type = (StatisticsType)this.statisticsTypeSerializer.deserialize(source);
        if (type == StatisticsType.Map) {
            int numPartitions = source.readInt();
            int mapSize = source.readInt();
            HashMap keyAssignments = Maps.newHashMapWithExpectedSize((int)mapSize);
            for (int i = 0; i < mapSize; ++i) {
                SortKey sortKey = (SortKey)this.sortKeySerializer.deserialize(source);
                List assignedSubtasks = this.intsSerializer.deserialize(source);
                List subtaskWeightsWithCloseFileCost = this.longsSerializer.deserialize(source);
                long closeFileCostWeight = source.readLong();
                keyAssignments.put(sortKey, new KeyAssignment(assignedSubtasks, subtaskWeightsWithCloseFileCost, closeFileCostWeight));
            }
            return GlobalStatistics.fromMapAssignment(checkpointId, new MapAssignment(numPartitions, keyAssignments));
        }
        List sortKeys = this.rangeBoundsSerializer.deserialize(source);
        SortKey[] rangeBounds = new SortKey[sortKeys.size()];
        return GlobalStatistics.fromRangeBounds(checkpointId, sortKeys.toArray(rangeBounds));
    }

    public GlobalStatistics deserialize(GlobalStatistics reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GlobalStatisticsSerializer other = (GlobalStatisticsSerializer)((Object)obj);
        return Objects.equals(this.sortKeySerializer, other.sortKeySerializer);
    }

    public int hashCode() {
        return this.sortKeySerializer.hashCode();
    }

    public TypeSerializerSnapshot<GlobalStatistics> snapshotConfiguration() {
        return new GlobalStatisticsSerializerSnapshot(this);
    }

    public static class GlobalStatisticsSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<GlobalStatistics, GlobalStatisticsSerializer> {
        private static final int CURRENT_VERSION = 1;

        public GlobalStatisticsSerializerSnapshot() {
        }

        public GlobalStatisticsSerializerSnapshot(GlobalStatisticsSerializer serializer) {
            super((TypeSerializer)serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(GlobalStatisticsSerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.sortKeySerializer};
        }

        protected GlobalStatisticsSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            SortKeySerializer sortKeySerializer = (SortKeySerializer)nestedSerializers[0];
            return new GlobalStatisticsSerializer(sortKeySerializer);
        }
    }
}

