/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.types.CheckCompatibility;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class SortKeySerializer
extends TypeSerializer<SortKey> {
    private final Schema schema;
    private final SortOrder sortOrder;
    private final int size;
    private final Types.NestedField[] transformedFields;
    private int version;
    private transient SortKey sortKey;

    SortKeySerializer(Schema schema, SortOrder sortOrder, int version) {
        this.version = version;
        this.schema = schema;
        this.sortOrder = sortOrder;
        this.size = sortOrder.fields().size();
        this.transformedFields = new Types.NestedField[this.size];
        for (int i = 0; i < this.size; ++i) {
            Types.NestedField transformedField;
            SortField sortField = (SortField)sortOrder.fields().get(i);
            Types.NestedField sourceField = schema.findField(sortField.sourceId());
            Type resultType = sortField.transform().getResultType(sourceField.type());
            this.transformedFields[i] = transformedField = Types.NestedField.of((int)sourceField.fieldId(), (boolean)sourceField.isOptional(), (String)sourceField.name(), (Type)resultType, (String)sourceField.doc());
        }
    }

    SortKeySerializer(Schema schema, SortOrder sortOrder) {
        this(schema, sortOrder, 2);
    }

    private SortKey lazySortKey() {
        if (this.sortKey == null) {
            this.sortKey = new SortKey(this.schema, this.sortOrder);
        }
        return this.sortKey;
    }

    public int getLatestVersion() {
        return this.snapshotConfiguration().getCurrentVersion();
    }

    public void restoreToLatestVersion() {
        this.version = this.snapshotConfiguration().getCurrentVersion();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<SortKey> duplicate() {
        return new SortKeySerializer(this.schema, this.sortOrder);
    }

    public SortKey createInstance() {
        return new SortKey(this.schema, this.sortOrder);
    }

    public SortKey copy(SortKey from) {
        return from.copy();
    }

    public SortKey copy(SortKey from, SortKey reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(SortKey record, DataOutputView target) throws IOException {
        Preconditions.checkArgument((record.size() == this.size ? 1 : 0) != 0, (String)"Invalid size of the sort key object: %s. Expected %s", (Object[])new Object[]{record.size(), this.size});
        block11: for (int i = 0; i < this.size; ++i) {
            int fieldId = this.transformedFields[i].fieldId();
            Type.TypeID typeId = this.transformedFields[i].type().typeId();
            if (this.version > 1) {
                Object value = record.get(i, Object.class);
                if (value == null) {
                    target.writeBoolean(true);
                    continue;
                }
                target.writeBoolean(false);
            }
            switch (typeId) {
                case BOOLEAN: {
                    target.writeBoolean(((Boolean)record.get(i, Boolean.class)).booleanValue());
                    continue block11;
                }
                case INTEGER: 
                case DATE: {
                    target.writeInt(((Integer)record.get(i, Integer.class)).intValue());
                    continue block11;
                }
                case LONG: 
                case TIME: 
                case TIMESTAMP: {
                    target.writeLong(((Long)record.get(i, Long.class)).longValue());
                    continue block11;
                }
                case FLOAT: {
                    target.writeFloat(((Float)record.get(i, Float.class)).floatValue());
                    continue block11;
                }
                case DOUBLE: {
                    target.writeDouble(((Double)record.get(i, Double.class)).doubleValue());
                    continue block11;
                }
                case STRING: {
                    target.writeUTF(((CharSequence)record.get(i, CharSequence.class)).toString());
                    continue block11;
                }
                case UUID: {
                    UUID uuid = (UUID)record.get(i, UUID.class);
                    target.writeLong(uuid.getMostSignificantBits());
                    target.writeLong(uuid.getLeastSignificantBits());
                    continue block11;
                }
                case FIXED: 
                case BINARY: {
                    byte[] bytes = ((ByteBuffer)record.get(i, ByteBuffer.class)).array();
                    target.writeInt(bytes.length);
                    target.write(bytes);
                    continue block11;
                }
                case DECIMAL: {
                    BigDecimal decimal = (BigDecimal)record.get(i, BigDecimal.class);
                    byte[] decimalBytes = decimal.unscaledValue().toByteArray();
                    target.writeInt(decimalBytes.length);
                    target.write(decimalBytes);
                    target.writeInt(decimal.scale());
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException(String.format(Locale.ROOT, "Field %d has unsupported field type: %s", fieldId, typeId));
                }
            }
        }
    }

    public SortKey deserialize(DataInputView source) throws IOException {
        SortKey deserialized = this.lazySortKey().copy();
        this.deserialize(deserialized, source);
        return deserialized;
    }

    public SortKey deserialize(SortKey reuse, DataInputView source) throws IOException {
        Preconditions.checkArgument((reuse.size() == this.size ? 1 : 0) != 0, (String)"Invalid size of the sort key object: %s. Expected %s", (Object[])new Object[]{reuse.size(), this.size});
        block11: for (int i = 0; i < this.size; ++i) {
            boolean isNull;
            if (this.version > 1 && (isNull = source.readBoolean())) {
                reuse.set(i, null);
                continue;
            }
            int fieldId = this.transformedFields[i].fieldId();
            Type.TypeID typeId = this.transformedFields[i].type().typeId();
            switch (typeId) {
                case BOOLEAN: {
                    reuse.set(i, (Object)source.readBoolean());
                    continue block11;
                }
                case INTEGER: 
                case DATE: {
                    reuse.set(i, (Object)source.readInt());
                    continue block11;
                }
                case LONG: 
                case TIME: 
                case TIMESTAMP: {
                    reuse.set(i, (Object)source.readLong());
                    continue block11;
                }
                case FLOAT: {
                    reuse.set(i, (Object)Float.valueOf(source.readFloat()));
                    continue block11;
                }
                case DOUBLE: {
                    reuse.set(i, (Object)source.readDouble());
                    continue block11;
                }
                case STRING: {
                    reuse.set(i, (Object)source.readUTF());
                    continue block11;
                }
                case UUID: {
                    long mostSignificantBits = source.readLong();
                    long leastSignificantBits = source.readLong();
                    reuse.set(i, (Object)new UUID(mostSignificantBits, leastSignificantBits));
                    continue block11;
                }
                case FIXED: 
                case BINARY: {
                    byte[] bytes = new byte[source.readInt()];
                    source.read(bytes);
                    reuse.set(i, (Object)ByteBuffer.wrap(bytes));
                    continue block11;
                }
                case DECIMAL: {
                    byte[] unscaledBytes = new byte[source.readInt()];
                    source.read(unscaledBytes);
                    int scale = source.readInt();
                    BigDecimal decimal = new BigDecimal(new BigInteger(unscaledBytes), scale);
                    reuse.set(i, (Object)decimal);
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException(String.format(Locale.ROOT, "Field %d has unsupported field type: %s", fieldId, typeId));
                }
            }
        }
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SortKeySerializer)) {
            return false;
        }
        SortKeySerializer other = (SortKeySerializer)((Object)obj);
        return Objects.equals(this.schema.asStruct(), other.schema.asStruct()) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public int hashCode() {
        return this.schema.asStruct().hashCode() * 31 + this.sortOrder.hashCode();
    }

    public TypeSerializerSnapshot<SortKey> snapshotConfiguration() {
        return new SortKeySerializerSnapshot(this.schema, this.sortOrder);
    }

    public static class SortKeySerializerSnapshot
    implements TypeSerializerSnapshot<SortKey> {
        private static final int CURRENT_VERSION = 2;
        private Schema schema;
        private SortOrder sortOrder;
        private int version = 2;

        public SortKeySerializerSnapshot() {
        }

        public SortKeySerializerSnapshot(Schema schema, SortOrder sortOrder) {
            this.schema = schema;
            this.sortOrder = sortOrder;
        }

        public int getCurrentVersion() {
            return 2;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            Preconditions.checkState((this.schema != null ? 1 : 0) != 0, (Object)"Invalid schema: null");
            Preconditions.checkState((this.sortOrder != null ? 1 : 0) != 0, (Object)"Invalid sort order: null");
            StringUtils.writeString((String)SchemaParser.toJson((Schema)this.schema), (DataOutputView)out);
            StringUtils.writeString((String)SortOrderParser.toJson((SortOrder)this.sortOrder), (DataOutputView)out);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            switch (readVersion) {
                case 1: {
                    this.read(in);
                    this.version = 1;
                    break;
                }
                case 2: {
                    this.read(in);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown read version: " + readVersion);
                }
            }
        }

        public TypeSerializerSchemaCompatibility<SortKey> resolveSchemaCompatibility(TypeSerializerSnapshot<SortKey> oldSerializerSnapshot) {
            Schema oldSortSchema;
            if (!(oldSerializerSnapshot instanceof SortKeySerializerSnapshot)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            if (oldSerializerSnapshot.getCurrentVersion() == 1 && this.getCurrentVersion() == 2) {
                return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
            }
            SortKeySerializerSnapshot oldSnapshot = (SortKeySerializerSnapshot)oldSerializerSnapshot;
            if (!this.sortOrder.sameOrder(oldSnapshot.sortOrder)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            Set sortFieldIds = this.sortOrder.fields().stream().map(SortField::sourceId).collect(Collectors.toSet());
            Schema sortSchema = TypeUtil.project((Schema)this.schema, sortFieldIds);
            List compatibilityErrors = CheckCompatibility.writeCompatibilityErrors((Schema)sortSchema, (Schema)(oldSortSchema = TypeUtil.project((Schema)oldSnapshot.schema, sortFieldIds)));
            if (compatibilityErrors.isEmpty()) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
            return TypeSerializerSchemaCompatibility.incompatible();
        }

        public TypeSerializer<SortKey> restoreSerializer() {
            Preconditions.checkState((this.schema != null ? 1 : 0) != 0, (Object)"Invalid schema: null");
            Preconditions.checkState((this.sortOrder != null ? 1 : 0) != 0, (Object)"Invalid sort order: null");
            return new SortKeySerializer(this.schema, this.sortOrder, this.version);
        }

        private void read(DataInputView in) throws IOException {
            String schemaJson = StringUtils.readString((DataInputView)in);
            String sortOrderJson = StringUtils.readString((DataInputView)in);
            this.schema = SchemaParser.fromJson((String)schemaJson);
            this.sortOrder = SortOrderParser.fromJson((String)sortOrderJson).bind(this.schema);
        }
    }
}

