/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class SortKeyUtil {
    private SortKeyUtil() {
    }

    static Schema sortKeySchema(Schema schema, SortOrder sortOrder) {
        List sortFields = sortOrder.fields();
        int size = sortFields.size();
        ArrayList transformedFields = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            int sourceFieldId = ((SortField)sortFields.get(i)).sourceId();
            Types.NestedField sourceField = schema.findField(sourceFieldId);
            Preconditions.checkArgument((sourceField != null ? 1 : 0) != 0, (String)"Cannot find source field: %s", (int)sourceFieldId);
            Type transformedType = ((SortField)sortFields.get(i)).transform().getResultType(sourceField.type());
            Types.NestedField transformedField = Types.NestedField.of((int)i, (boolean)sourceField.isOptional(), (String)(sourceField.name() + "_" + i), (Type)transformedType, (String)sourceField.doc());
            transformedFields.add(transformedField);
        }
        return new Schema((List)transformedFields);
    }
}

