/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.InputFilesDecryptor;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Internal
public class DataIterator<T>
implements CloseableIterator<T> {
    private final FileScanTaskReader<T> fileScanTaskReader;
    private final InputFilesDecryptor inputFilesDecryptor;
    private final CombinedScanTask combinedTask;
    private Iterator<FileScanTask> tasks;
    private CloseableIterator<T> currentIterator;
    private int fileOffset;
    private long recordOffset;

    public DataIterator(FileScanTaskReader<T> fileScanTaskReader, CombinedScanTask task, FileIO io, EncryptionManager encryption) {
        this.fileScanTaskReader = fileScanTaskReader;
        this.inputFilesDecryptor = new InputFilesDecryptor(task, io, encryption);
        this.combinedTask = task;
        this.tasks = task.files().iterator();
        this.currentIterator = CloseableIterator.empty();
        this.fileOffset = -1;
        this.recordOffset = 0L;
    }

    public void seek(int startingFileOffset, long startingRecordOffset) {
        long i;
        Preconditions.checkState((this.fileOffset == -1 ? 1 : 0) != 0, (Object)"Seek should be called before any other iterator actions");
        Preconditions.checkState((startingFileOffset < this.combinedTask.files().size() ? 1 : 0) != 0, (String)"Invalid starting file offset %s for combined scan task with %s files: %s", (Object)startingFileOffset, (Object)this.combinedTask.files().size(), (Object)this.combinedTask);
        for (i = 0L; i < (long)startingFileOffset; ++i) {
            this.tasks.next();
        }
        this.updateCurrentIterator();
        for (i = 0L; i < startingRecordOffset; ++i) {
            if (!this.currentFileHasNext() || !this.hasNext()) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Invalid starting record offset %d for file %d from CombinedScanTask: %s", startingRecordOffset, startingFileOffset, this.combinedTask));
            }
            this.next();
        }
        this.fileOffset = startingFileOffset;
        this.recordOffset = startingRecordOffset;
    }

    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    public T next() {
        this.updateCurrentIterator();
        ++this.recordOffset;
        return (T)this.currentIterator.next();
    }

    public boolean currentFileHasNext() {
        return this.currentIterator.hasNext();
    }

    private void updateCurrentIterator() {
        try {
            while (!this.currentIterator.hasNext() && this.tasks.hasNext()) {
                this.currentIterator.close();
                this.currentIterator = this.openTaskIterator(this.tasks.next());
                ++this.fileOffset;
                this.recordOffset = 0L;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CloseableIterator<T> openTaskIterator(FileScanTask scanTask) {
        return this.fileScanTaskReader.open(scanTask, this.inputFilesDecryptor);
    }

    public void close() throws IOException {
        this.currentIterator.close();
        this.tasks = null;
    }

    public int fileOffset() {
        return this.fileOffset;
    }

    public long recordOffset() {
        return this.recordOffset;
    }
}

