/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.flink.FlinkSchemaUtil;

@Internal
public class RowDataToAvroGenericRecordConverter
implements Function<RowData, GenericRecord> {
    private final RowDataToAvroConverters.RowDataToAvroConverter converter;
    private final org.apache.avro.Schema avroSchema;

    private RowDataToAvroGenericRecordConverter(RowType rowType, org.apache.avro.Schema avroSchema) {
        this.converter = RowDataToAvroConverters.createConverter((LogicalType)rowType);
        this.avroSchema = avroSchema;
    }

    @Override
    public GenericRecord apply(RowData rowData) {
        return (GenericRecord)this.converter.convert(this.avroSchema, (Object)rowData);
    }

    public static RowDataToAvroGenericRecordConverter fromIcebergSchema(String tableName, Schema icebergSchema) {
        RowType rowType = FlinkSchemaUtil.convert(icebergSchema);
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)icebergSchema, (String)tableName);
        return new RowDataToAvroGenericRecordConverter(rowType, avroSchema);
    }

    public static RowDataToAvroGenericRecordConverter fromAvroSchema(org.apache.avro.Schema avroSchema) {
        DataType dataType = AvroSchemaConverter.convertToDataType((String)avroSchema.toString());
        LogicalType logicalType = TypeConversions.fromDataToLogicalType((DataType)dataType);
        RowType rowType = RowType.of((LogicalType[])logicalType.getChildren().toArray(new LogicalType[0]));
        return new RowDataToAvroGenericRecordConverter(rowType, avroSchema);
    }
}

