/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.DataTaskReader;
import org.apache.iceberg.flink.source.reader.ArrayPoolDataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.DataIteratorReaderFunction;
import org.apache.iceberg.flink.source.reader.RowDataRecordFactory;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Internal
public class MetaDataReaderFunction
extends DataIteratorReaderFunction<RowData> {
    private final Schema readSchema;
    private final FileIO io;
    private final EncryptionManager encryption;

    public MetaDataReaderFunction(ReadableConfig config, Schema tableSchema, Schema projectedSchema, FileIO io, EncryptionManager encryption) {
        super(new ArrayPoolDataIteratorBatcher<RowData>(config, new RowDataRecordFactory(FlinkSchemaUtil.convert(MetaDataReaderFunction.readSchema(tableSchema, projectedSchema)))));
        this.readSchema = MetaDataReaderFunction.readSchema(tableSchema, projectedSchema);
        this.io = io;
        this.encryption = encryption;
    }

    @Override
    public DataIterator<RowData> createDataIterator(IcebergSourceSplit split) {
        return new DataIterator<RowData>(new DataTaskReader(this.readSchema), split.task(), this.io, this.encryption);
    }

    private static Schema readSchema(Schema tableSchema, Schema projectedSchema) {
        Preconditions.checkNotNull((Object)tableSchema, (Object)"Table schema can't be null");
        return projectedSchema == null ? tableSchema : projectedSchema;
    }
}

