/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.source.reader.RowDataConverter;

public class RowConverter
implements RowDataConverter<Row> {
    private final DataStructureConverter<Object, Object> converter;
    private final TypeInformation<Row> outputTypeInfo;

    private RowConverter(RowType rowType, TypeInformation<Row> rowTypeInfo) {
        this.converter = DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)rowType));
        this.outputTypeInfo = rowTypeInfo;
    }

    public static RowConverter fromIcebergSchema(Schema icebergSchema) {
        RowType rowType = FlinkSchemaUtil.convert(icebergSchema);
        TableSchema tableSchema = FlinkSchemaUtil.toSchema(icebergSchema);
        TypeInformation[] typeInformations = (TypeInformation[])Stream.of(tableSchema.getFieldDataTypes()).map(ExternalTypeInfo::of).toArray(TypeInformation[]::new);
        RowTypeInfo rowTypeInfo = new RowTypeInfo(typeInformations, tableSchema.getFieldNames());
        return new RowConverter(rowType, (TypeInformation<Row>)rowTypeInfo);
    }

    @Override
    public Row apply(RowData rowData) {
        return (Row)this.converter.toExternal((Object)rowData);
    }

    public TypeInformation<Row> getProducedType() {
        return this.outputTypeInfo;
    }
}

