/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskParser;
import org.apache.iceberg.flink.source.split.SerializerHelper;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

@Internal
public class IcebergSourceSplit
implements SourceSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(1024));
    private final CombinedScanTask task;
    private int fileOffset;
    private long recordOffset;
    @Nullable
    private transient byte[] serializedBytesCache;

    private IcebergSourceSplit(CombinedScanTask task, int fileOffset, long recordOffset) {
        this.task = task;
        this.fileOffset = fileOffset;
        this.recordOffset = recordOffset;
    }

    public static IcebergSourceSplit fromCombinedScanTask(CombinedScanTask combinedScanTask) {
        return IcebergSourceSplit.fromCombinedScanTask(combinedScanTask, 0, 0L);
    }

    public static IcebergSourceSplit fromCombinedScanTask(CombinedScanTask combinedScanTask, int fileOffset, long recordOffset) {
        return new IcebergSourceSplit(combinedScanTask, fileOffset, recordOffset);
    }

    public CombinedScanTask task() {
        return this.task;
    }

    public int fileOffset() {
        return this.fileOffset;
    }

    public long recordOffset() {
        return this.recordOffset;
    }

    public String splitId() {
        return MoreObjects.toStringHelper((Object)this).add("files", (Object)this.toString(this.task.files())).toString();
    }

    public void updatePosition(int newFileOffset, long newRecordOffset) {
        this.serializedBytesCache = null;
        this.fileOffset = newFileOffset;
        this.recordOffset = newRecordOffset;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("files", (Object)this.toString(this.task.files())).add("fileOffset", this.fileOffset).add("recordOffset", this.recordOffset).toString();
    }

    private String toString(Collection<FileScanTask> files) {
        return Iterables.toString((Iterable)files.stream().map(fileScanTask -> MoreObjects.toStringHelper((Object)fileScanTask).add("file", (Object)((DataFile)fileScanTask.file()).location()).add("start", fileScanTask.start()).add("length", fileScanTask.length()).toString()).collect(Collectors.toList()));
    }

    byte[] serializeV1() throws IOException {
        if (this.serializedBytesCache == null) {
            this.serializedBytesCache = InstantiationUtil.serializeObject((Object)this);
        }
        return this.serializedBytesCache;
    }

    static IcebergSourceSplit deserializeV1(byte[] serialized) throws IOException {
        try {
            return (IcebergSourceSplit)InstantiationUtil.deserializeObject((byte[])serialized, (ClassLoader)IcebergSourceSplit.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize the split.", e);
        }
    }

    byte[] serializeV2() throws IOException {
        return this.serialize(2);
    }

    byte[] serializeV3() throws IOException {
        return this.serialize(3);
    }

    private byte[] serialize(int version) throws IOException {
        if (this.serializedBytesCache == null) {
            DataOutputSerializer out = SERIALIZER_CACHE.get();
            Collection fileScanTasks = this.task.tasks();
            Preconditions.checkArgument((this.fileOffset >= 0 && this.fileOffset < fileScanTasks.size() ? 1 : 0) != 0, (String)"Invalid file offset: %s. Should be within the range of [0, %s)", (int)this.fileOffset, (int)fileScanTasks.size());
            out.writeInt(this.fileOffset);
            out.writeLong(this.recordOffset);
            out.writeInt(fileScanTasks.size());
            for (FileScanTask fileScanTask : fileScanTasks) {
                String taskJson = ScanTaskParser.toJson((FileScanTask)fileScanTask);
                IcebergSourceSplit.writeTaskJson(out, taskJson, version);
            }
            this.serializedBytesCache = out.getCopyOfBuffer();
            out.clear();
        }
        return this.serializedBytesCache;
    }

    private static void writeTaskJson(DataOutputSerializer out, String taskJson, int version) throws IOException {
        switch (version) {
            case 2: {
                out.writeUTF(taskJson);
                break;
            }
            case 3: {
                SerializerHelper.writeLongUTF(out, taskJson);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported version: " + version);
            }
        }
    }

    static IcebergSourceSplit deserializeV2(byte[] serialized, boolean caseSensitive) throws IOException {
        return IcebergSourceSplit.deserialize(serialized, caseSensitive, 2);
    }

    static IcebergSourceSplit deserializeV3(byte[] serialized, boolean caseSensitive) throws IOException {
        return IcebergSourceSplit.deserialize(serialized, caseSensitive, 3);
    }

    private static IcebergSourceSplit deserialize(byte[] serialized, boolean caseSensitive, int version) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int fileOffset = in.readInt();
        long recordOffset = in.readLong();
        int taskCount = in.readInt();
        ArrayList tasks = Lists.newArrayListWithCapacity((int)taskCount);
        for (int i = 0; i < taskCount; ++i) {
            String taskJson = IcebergSourceSplit.readTaskJson(in, version);
            FileScanTask task = ScanTaskParser.fromJson((String)taskJson, (boolean)caseSensitive);
            tasks.add(task);
        }
        BaseCombinedScanTask combinedScanTask = new BaseCombinedScanTask((List)tasks);
        return IcebergSourceSplit.fromCombinedScanTask((CombinedScanTask)combinedScanTask, fileOffset, recordOffset);
    }

    private static String readTaskJson(DataInputDeserializer in, int version) throws IOException {
        switch (version) {
            case 2: {
                return in.readUTF();
            }
            case 3: {
                return SerializerHelper.readLongUTF(in);
            }
        }
        throw new IllegalArgumentException("Unsupported version: " + version);
    }
}

