/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.flink.source.reader.SplitWatermarkExtractor;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.SerializableComparator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class SplitComparators {
    private SplitComparators() {
    }

    public static SerializableComparator<IcebergSourceSplit> fileSequenceNumber() {
        return (o1, o2) -> {
            Preconditions.checkArgument((o1.task().files().size() == 1 && o2.task().files().size() == 1 ? 1 : 0) != 0, (String)"Could not compare combined task. Please use '%s' to prevent combining multiple files to a split", (Object)"split-file-open-cost");
            Long seq1 = ((DataFile)((FileScanTask)o1.task().files().iterator().next()).file()).fileSequenceNumber();
            Long seq2 = ((DataFile)((FileScanTask)o2.task().files().iterator().next()).file()).fileSequenceNumber();
            Preconditions.checkNotNull((Object)seq1, (String)"Invalid file sequence number: null. Doesn't support splits written with V1 format: %s", (Object)o1);
            Preconditions.checkNotNull((Object)seq2, (String)"Invalid file sequence number: null. Doesn't support splits written with V1 format: %s", (Object)o2);
            int temp = Long.compare(seq1, seq2);
            if (temp != 0) {
                return temp;
            }
            return o1.splitId().compareTo(o2.splitId());
        };
    }

    public static SerializableComparator<IcebergSourceSplit> watermark(SplitWatermarkExtractor watermarkExtractor) {
        return (o1, o2) -> {
            long watermark2;
            long watermark1 = watermarkExtractor.extractWatermark((IcebergSourceSplit)o1);
            int temp = Long.compare(watermark1, watermark2 = watermarkExtractor.extractWatermark((IcebergSourceSplit)o2));
            if (temp != 0) {
                return temp;
            }
            return o1.splitId().compareTo(o2.splitId());
        };
    }
}

