/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.util;

import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.Gauge;

@Internal
public class ElapsedTimeGauge
implements Gauge<Long> {
    private final TimeUnit reportUnit;
    private volatile long lastRecordedTimeNano;

    public ElapsedTimeGauge(TimeUnit timeUnit) {
        this.reportUnit = timeUnit;
        this.refreshLastRecordedTime();
    }

    public void refreshLastRecordedTime() {
        this.lastRecordedTimeNano = System.nanoTime();
    }

    public Long getValue() {
        return this.reportUnit.convert(System.nanoTime() - this.lastRecordedTimeNano, TimeUnit.NANOSECONDS);
    }
}

