/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroWithPartnerVisitor;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.flink.data.FlinkValueReaders;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FlinkPlannedAvroReader
implements DatumReader<RowData>,
SupportsRowPosition {
    private final Types.StructType expectedType;
    private final Map<Integer, ?> idToConstant;
    private ValueReader<RowData> reader;

    public static FlinkPlannedAvroReader create(Schema schema) {
        return FlinkPlannedAvroReader.create(schema, ImmutableMap.of());
    }

    public static FlinkPlannedAvroReader create(Schema schema, Map<Integer, ?> constants) {
        return new FlinkPlannedAvroReader(schema, constants);
    }

    private FlinkPlannedAvroReader(Schema expectedSchema, Map<Integer, ?> constants) {
        this.expectedType = expectedSchema.asStruct();
        this.idToConstant = constants;
    }

    public void setSchema(org.apache.avro.Schema fileSchema) {
        this.reader = (ValueReader)AvroWithPartnerVisitor.visit((Object)this.expectedType, (org.apache.avro.Schema)fileSchema, (AvroWithPartnerVisitor)new ReadBuilder(this.idToConstant), (AvroWithPartnerVisitor.PartnerAccessors)AvroWithPartnerVisitor.FieldIDAccessors.get());
    }

    public RowData read(RowData reuse, Decoder decoder) throws IOException {
        return (RowData)this.reader.read(decoder, (Object)reuse);
    }

    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)this.reader).setRowPositionSupplier(posSupplier);
        }
    }

    private static class ReadBuilder
    extends AvroWithPartnerVisitor<Type, ValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public ValueReader<?> record(Type partner, org.apache.avro.Schema record, List<ValueReader<?>> fieldReaders) {
            if (partner == null) {
                return ValueReaders.skipStruct(fieldReaders);
            }
            Types.StructType expected = partner.asStructType();
            List readPlan = ValueReaders.buildReadPlan((Types.StructType)expected, (org.apache.avro.Schema)record, fieldReaders, this.idToConstant, RowDataUtil::convertConstant);
            return FlinkValueReaders.struct(readPlan, expected.fields().size());
        }

        public ValueReader<?> union(Type partner, org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        public ValueReader<?> array(Type partner, org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return FlinkValueReaders.array(elementReader);
        }

        public ValueReader<?> arrayMap(Type partner, org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return FlinkValueReaders.arrayMap(keyReader, valueReader);
        }

        public ValueReader<?> map(Type partner, org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return FlinkValueReaders.map(FlinkValueReaders.strings(), valueReader);
        }

        public ValueReader<?> primitive(Type partner, org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "time-micros": {
                        return FlinkValueReaders.timeMicros();
                    }
                    case "timestamp-millis": {
                        return FlinkValueReaders.timestampMills();
                    }
                    case "timestamp-micros": {
                        return FlinkValueReaders.timestampMicros();
                    }
                    case "timestamp-nanos": {
                        return FlinkValueReaders.timestampNanos();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return FlinkValueReaders.decimal((ValueReader<byte[]>)ValueReaders.decimalBytesReader((org.apache.avro.Schema)primitive), decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return FlinkValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType.getName());
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    if (partner != null && partner.typeId() == Type.TypeID.LONG) {
                        return ValueReaders.intsAsLongs();
                    }
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    if (partner != null && partner.typeId() == Type.TypeID.DOUBLE) {
                        return ValueReaders.floatsAsDoubles();
                    }
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return FlinkValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed((int)primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.bytes();
                }
                case ENUM: {
                    return FlinkValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

