/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.api;

import java.time.Duration;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.iceberg.flink.maintenance.api.MaintenanceTaskBuilder;
import org.apache.iceberg.flink.maintenance.api.TaskResult;
import org.apache.iceberg.flink.maintenance.api.Trigger;
import org.apache.iceberg.flink.maintenance.operator.DeleteFilesProcessor;
import org.apache.iceberg.flink.maintenance.operator.ExpireSnapshotsProcessor;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class ExpireSnapshots {
    private static final int DELETE_BATCH_SIZE_DEFAULT = 1000;
    private static final String EXECUTOR_OPERATOR_NAME = "Expire Snapshot";
    @VisibleForTesting
    static final String DELETE_FILES_OPERATOR_NAME = "Delete file";

    private ExpireSnapshots() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MaintenanceTaskBuilder<Builder> {
        private Duration maxSnapshotAge = null;
        private Integer numSnapshots = null;
        private Integer planningWorkerPoolSize;
        private int deleteBatchSize = 1000;

        public Builder maxSnapshotAge(Duration newMaxSnapshotAge) {
            this.maxSnapshotAge = newMaxSnapshotAge;
            return this;
        }

        public Builder retainLast(int newNumSnapshots) {
            this.numSnapshots = newNumSnapshots;
            return this;
        }

        public Builder planningWorkerPoolSize(int newPlanningWorkerPoolSize) {
            this.planningWorkerPoolSize = newPlanningWorkerPoolSize;
            return this;
        }

        public Builder deleteBatchSize(int newDeleteBatchSize) {
            this.deleteBatchSize = newDeleteBatchSize;
            return this;
        }

        @Override
        DataStream<TaskResult> append(DataStream<Trigger> trigger) {
            Preconditions.checkNotNull((Object)this.tableLoader(), (Object)"TableLoader should not be null");
            SingleOutputStreamOperator result = trigger.process((ProcessFunction)new ExpireSnapshotsProcessor(this.tableLoader(), this.maxSnapshotAge == null ? null : Long.valueOf(this.maxSnapshotAge.toMillis()), this.numSnapshots, this.planningWorkerPoolSize)).name(this.operatorName(ExpireSnapshots.EXECUTOR_OPERATOR_NAME)).uid(ExpireSnapshots.EXECUTOR_OPERATOR_NAME + this.uidSuffix()).slotSharingGroup(this.slotSharingGroup()).forceNonParallel();
            result.getSideOutput(ExpireSnapshotsProcessor.DELETE_STREAM).rebalance().transform(this.operatorName(ExpireSnapshots.DELETE_FILES_OPERATOR_NAME), TypeInformation.of(Void.class), (OneInputStreamOperator)new DeleteFilesProcessor(this.index(), this.taskName(), this.tableLoader().loadTable(), this.deleteBatchSize)).uid(ExpireSnapshots.DELETE_FILES_OPERATOR_NAME + this.uidSuffix()).slotSharingGroup(this.slotSharingGroup()).setParallelism(this.parallelism().intValue());
            return result;
        }
    }
}

