/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.Arrays;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.util.ScanTaskUtil;

class CommitSummary {
    private final AtomicLong dataFilesCount = new AtomicLong();
    private final AtomicLong dataFilesRecordCount = new AtomicLong();
    private final AtomicLong dataFilesByteCount = new AtomicLong();
    private final AtomicLong deleteFilesCount = new AtomicLong();
    private final AtomicLong deleteFilesRecordCount = new AtomicLong();
    private final AtomicLong deleteFilesByteCount = new AtomicLong();

    CommitSummary(NavigableMap<Long, WriteResult> pendingResults) {
        pendingResults.values().forEach(writeResult -> {
            this.dataFilesCount.addAndGet(writeResult.dataFiles().length);
            Arrays.stream(writeResult.dataFiles()).forEach(dataFile -> {
                this.dataFilesRecordCount.addAndGet(dataFile.recordCount());
                this.dataFilesByteCount.addAndGet(dataFile.fileSizeInBytes());
            });
            this.deleteFilesCount.addAndGet(writeResult.deleteFiles().length);
            Arrays.stream(writeResult.deleteFiles()).forEach(deleteFile -> {
                this.deleteFilesRecordCount.addAndGet(deleteFile.recordCount());
                long deleteBytes = ScanTaskUtil.contentSizeInBytes((ContentFile)deleteFile);
                this.deleteFilesByteCount.addAndGet(deleteBytes);
            });
        });
    }

    long dataFilesCount() {
        return this.dataFilesCount.get();
    }

    long dataFilesRecordCount() {
        return this.dataFilesRecordCount.get();
    }

    long dataFilesByteCount() {
        return this.dataFilesByteCount.get();
    }

    long deleteFilesCount() {
        return this.deleteFilesCount.get();
    }

    long deleteFilesRecordCount() {
        return this.deleteFilesRecordCount.get();
    }

    long deleteFilesByteCount() {
        return this.deleteFilesByteCount.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataFilesCount", (Object)this.dataFilesCount).add("dataFilesRecordCount", (Object)this.dataFilesRecordCount).add("dataFilesByteCount", (Object)this.dataFilesByteCount).add("deleteFilesCount", (Object)this.deleteFilesCount).add("deleteFilesRecordCount", (Object)this.deleteFilesRecordCount).add("deleteFilesByteCount", (Object)this.deleteFilesByteCount).toString();
    }
}

