/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.RowDataWrapper;

class PartitionKeySelector
implements KeySelector<RowData, String> {
    private final Schema schema;
    private final PartitionKey partitionKey;
    private final RowType flinkSchema;
    private transient RowDataWrapper rowDataWrapper;

    PartitionKeySelector(PartitionSpec spec, Schema schema, RowType flinkSchema) {
        this.schema = schema;
        this.partitionKey = new PartitionKey(spec, schema);
        this.flinkSchema = flinkSchema;
    }

    private RowDataWrapper lazyRowDataWrapper() {
        if (this.rowDataWrapper == null) {
            this.rowDataWrapper = new RowDataWrapper(this.flinkSchema, this.schema.asStruct());
        }
        return this.rowDataWrapper;
    }

    public String getKey(RowData row) {
        this.partitionKey.partition((StructLike)this.lazyRowDataWrapper().wrap(row));
        return this.partitionKey.toPath();
    }
}

