/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Arrays;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.MapAssignment;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class GlobalStatistics {
    private final long checkpointId;
    private final StatisticsType type;
    private final MapAssignment mapAssignment;
    private final SortKey[] rangeBounds;
    private transient Integer hashCode;

    GlobalStatistics(long checkpointId, StatisticsType type, MapAssignment mapAssignment, SortKey[] rangeBounds) {
        Preconditions.checkArgument((mapAssignment != null && rangeBounds == null || mapAssignment == null && rangeBounds != null ? 1 : 0) != 0, (Object)"Invalid key assignment or range bounds: both are non-null or null");
        this.checkpointId = checkpointId;
        this.type = type;
        this.mapAssignment = mapAssignment;
        this.rangeBounds = rangeBounds;
    }

    static GlobalStatistics fromMapAssignment(long checkpointId, MapAssignment mapAssignment) {
        return new GlobalStatistics(checkpointId, StatisticsType.Map, mapAssignment, null);
    }

    static GlobalStatistics fromRangeBounds(long checkpointId, SortKey[] rangeBounds) {
        return new GlobalStatistics(checkpointId, StatisticsType.Sketch, null, rangeBounds);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("checkpointId", this.checkpointId).add("type", (Object)this.type).add("mapAssignment", (Object)this.mapAssignment).add("rangeBounds", (Object)this.rangeBounds).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalStatistics)) {
            return false;
        }
        GlobalStatistics other = (GlobalStatistics)o;
        return Objects.equal((Object)this.checkpointId, (Object)other.checkpointId) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.mapAssignment, (Object)other.mapAssignment()) && Arrays.equals(this.rangeBounds, other.rangeBounds());
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = Objects.hashCode((Object[])new Object[]{this.checkpointId, this.type, this.mapAssignment, this.rangeBounds});
        }
        return this.hashCode;
    }

    long checkpointId() {
        return this.checkpointId;
    }

    StatisticsType type() {
        return this.type;
    }

    MapAssignment mapAssignment() {
        return this.mapAssignment;
    }

    SortKey[] rangeBounds() {
        return this.rangeBounds;
    }
}

