/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class KeyAssignment {
    private final List<Integer> assignedSubtasks;
    private final List<Long> subtaskWeightsWithCloseFileCost;
    private final long closeFileCostWeight;
    private final long[] subtaskWeightsExcludingCloseCost;
    private final long keyWeight;
    private final long[] cumulativeWeights;

    KeyAssignment(List<Integer> assignedSubtasks, List<Long> subtaskWeightsWithCloseFileCost, long closeFileCostWeight) {
        Preconditions.checkArgument((assignedSubtasks != null && !assignedSubtasks.isEmpty() ? 1 : 0) != 0, (Object)"Invalid assigned subtasks: null or empty");
        Preconditions.checkArgument((subtaskWeightsWithCloseFileCost != null && !subtaskWeightsWithCloseFileCost.isEmpty() ? 1 : 0) != 0, (Object)"Invalid assigned subtasks weights: null or empty");
        Preconditions.checkArgument((assignedSubtasks.size() == subtaskWeightsWithCloseFileCost.size() ? 1 : 0) != 0, (String)"Invalid assignment: size mismatch (tasks length = %s, weights length = %s)", (int)assignedSubtasks.size(), (int)subtaskWeightsWithCloseFileCost.size());
        subtaskWeightsWithCloseFileCost.forEach(weight -> Preconditions.checkArgument((weight > closeFileCostWeight ? 1 : 0) != 0, (String)"Invalid weight: should be larger than close file cost: weight = %s, close file cost = %s", (Object)weight, (long)closeFileCostWeight));
        this.assignedSubtasks = assignedSubtasks;
        this.subtaskWeightsWithCloseFileCost = subtaskWeightsWithCloseFileCost;
        this.closeFileCostWeight = closeFileCostWeight;
        this.subtaskWeightsExcludingCloseCost = subtaskWeightsWithCloseFileCost.stream().mapToLong(weightWithCloseFileCost -> weightWithCloseFileCost - closeFileCostWeight).toArray();
        this.keyWeight = Arrays.stream(this.subtaskWeightsExcludingCloseCost).sum();
        this.cumulativeWeights = new long[this.subtaskWeightsExcludingCloseCost.length];
        long cumulativeWeight = 0L;
        for (int i = 0; i < this.subtaskWeightsExcludingCloseCost.length; ++i) {
            this.cumulativeWeights[i] = cumulativeWeight += this.subtaskWeightsExcludingCloseCost[i];
        }
    }

    List<Integer> assignedSubtasks() {
        return this.assignedSubtasks;
    }

    List<Long> subtaskWeightsWithCloseFileCost() {
        return this.subtaskWeightsWithCloseFileCost;
    }

    long closeFileCostWeight() {
        return this.closeFileCostWeight;
    }

    long[] subtaskWeightsExcludingCloseCost() {
        return this.subtaskWeightsExcludingCloseCost;
    }

    int select() {
        if (this.assignedSubtasks.size() == 1) {
            return this.assignedSubtasks.get(0);
        }
        long randomNumber = ThreadLocalRandom.current().nextLong(this.keyWeight);
        int index = Arrays.binarySearch(this.cumulativeWeights, randomNumber);
        int position = Math.abs(index + 1);
        Preconditions.checkState((position < this.assignedSubtasks.size() ? 1 : 0) != 0, (String)"Invalid selected position: out of range. key weight = %s, random number = %s, cumulative weights array = %s", (Object)this.keyWeight, (Object)randomNumber, (Object)this.cumulativeWeights);
        return this.assignedSubtasks.get(position);
    }

    public int hashCode() {
        return Objects.hash(this.assignedSubtasks, this.subtaskWeightsWithCloseFileCost, this.closeFileCostWeight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAssignment that = (KeyAssignment)o;
        return Objects.equals(this.assignedSubtasks, that.assignedSubtasks) && Objects.equals(this.subtaskWeightsWithCloseFileCost, that.subtaskWeightsWithCloseFileCost) && this.closeFileCostWeight == that.closeFileCostWeight;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("assignedSubtasks", this.assignedSubtasks).add("subtaskWeightsWithCloseFileCost", this.subtaskWeightsWithCloseFileCost).add("closeFileCostWeight", this.closeFileCostWeight).toString();
    }
}

