/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.sink.shuffle.KeyAssignment;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapAssignment {
    private static final Logger LOG = LoggerFactory.getLogger(MapAssignment.class);
    private final int numPartitions;
    private final Map<SortKey, KeyAssignment> keyAssignments;

    MapAssignment(int numPartitions, Map<SortKey, KeyAssignment> keyAssignments) {
        Preconditions.checkArgument((keyAssignments != null ? 1 : 0) != 0, (Object)"Invalid key assignments: null");
        this.numPartitions = numPartitions;
        this.keyAssignments = keyAssignments;
    }

    static MapAssignment fromKeyFrequency(int numPartitions, Map<SortKey, Long> mapStatistics, double closeFileCostWeightPercentage, Comparator<StructLike> comparator) {
        return new MapAssignment(numPartitions, MapAssignment.assignment(numPartitions, mapStatistics, closeFileCostWeightPercentage, comparator));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numPartitions, this.keyAssignments});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapAssignment that = (MapAssignment)o;
        return this.numPartitions == that.numPartitions && this.keyAssignments.equals(that.keyAssignments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numPartitions", this.numPartitions).add("keyAssignments", this.keyAssignments).toString();
    }

    int numPartitions() {
        return this.numPartitions;
    }

    Map<SortKey, KeyAssignment> keyAssignments() {
        return this.keyAssignments;
    }

    Map<Integer, Pair<Long, Integer>> assignmentInfo() {
        TreeMap assignmentInfo = Maps.newTreeMap();
        this.keyAssignments.forEach((key, keyAssignment) -> {
            for (int i = 0; i < keyAssignment.assignedSubtasks().size(); ++i) {
                int subtaskId = keyAssignment.assignedSubtasks().get(i);
                long subtaskWeight = keyAssignment.subtaskWeightsExcludingCloseCost()[i];
                Pair oldValue = assignmentInfo.getOrDefault(subtaskId, Pair.of((Object)0L, (Object)0));
                assignmentInfo.put(subtaskId, Pair.of((Object)((Long)oldValue.first() + subtaskWeight), (Object)((Integer)oldValue.second() + 1)));
            }
        });
        return assignmentInfo;
    }

    static Map<SortKey, KeyAssignment> assignment(int numPartitions, Map<SortKey, Long> mapStatistics, double closeFileCostWeightPercentage, Comparator<StructLike> comparator) {
        mapStatistics.forEach((key, value) -> Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (String)"Invalid statistics: weight is 0 for key %s", (Object)key));
        long totalWeight = mapStatistics.values().stream().mapToLong(l -> l).sum();
        double targetWeightPerSubtask = (double)totalWeight / (double)numPartitions;
        long closeFileCostWeight = (long)Math.ceil(targetWeightPerSubtask * closeFileCostWeightPercentage / 100.0);
        TreeMap sortedStatsWithCloseFileCost = Maps.newTreeMap(comparator);
        mapStatistics.forEach((k, v) -> {
            int estimatedSplits = (int)Math.ceil((double)v.longValue() / targetWeightPerSubtask);
            long estimatedCloseFileCost = closeFileCostWeight * (long)estimatedSplits;
            sortedStatsWithCloseFileCost.put(k, v + estimatedCloseFileCost);
        });
        long totalWeightWithCloseFileCost = sortedStatsWithCloseFileCost.values().stream().mapToLong(l -> l).sum();
        long targetWeightPerSubtaskWithCloseFileCost = (long)Math.ceil((double)totalWeightWithCloseFileCost / (double)numPartitions);
        return MapAssignment.buildAssignment(numPartitions, sortedStatsWithCloseFileCost, targetWeightPerSubtaskWithCloseFileCost, closeFileCostWeight);
    }

    private static Map<SortKey, KeyAssignment> buildAssignment(int numPartitions, NavigableMap<SortKey, Long> sortedStatistics, long targetWeightPerSubtask, long closeFileCostWeight) {
        HashMap assignmentMap = Maps.newHashMapWithExpectedSize((int)sortedStatistics.size());
        Iterator mapKeyIterator = sortedStatistics.keySet().iterator();
        int subtaskId = 0;
        SortKey currentKey = null;
        long keyRemainingWeight = 0L;
        long subtaskRemainingWeight = targetWeightPerSubtask;
        ArrayList assignedSubtasks = Lists.newArrayList();
        ArrayList subtaskWeights = Lists.newArrayList();
        while (mapKeyIterator.hasNext() || currentKey != null) {
            if (subtaskId >= numPartitions) {
                LOG.error("Internal algorithm error: exhausted subtasks with unassigned keys left. number of partitions: {}, target weight per subtask: {}, close file cost in weight: {}, data statistics: {}", new Object[]{numPartitions, targetWeightPerSubtask, closeFileCostWeight, sortedStatistics});
                throw new IllegalStateException("Internal algorithm error: exhausted subtasks with unassigned keys left");
            }
            if (currentKey == null) {
                currentKey = (SortKey)mapKeyIterator.next();
                keyRemainingWeight = (Long)sortedStatistics.get(currentKey);
            }
            assignedSubtasks.add(subtaskId);
            if (keyRemainingWeight < subtaskRemainingWeight) {
                subtaskWeights.add(keyRemainingWeight);
                subtaskRemainingWeight -= keyRemainingWeight;
                keyRemainingWeight = 0L;
            } else {
                long assignedWeight = subtaskRemainingWeight;
                keyRemainingWeight -= subtaskRemainingWeight;
                if (assignedWeight <= closeFileCostWeight) {
                    long paddingWeight = Math.min(keyRemainingWeight, closeFileCostWeight);
                    keyRemainingWeight -= paddingWeight;
                    assignedWeight += paddingWeight;
                }
                subtaskWeights.add(assignedWeight);
                ++subtaskId;
                subtaskRemainingWeight = targetWeightPerSubtask;
            }
            Preconditions.checkState((assignedSubtasks.size() == subtaskWeights.size() ? 1 : 0) != 0, (String)"List size mismatch: assigned subtasks = %s, subtask weights = %s", (Object)assignedSubtasks, (Object)subtaskWeights);
            if (keyRemainingWeight > 0L && keyRemainingWeight <= closeFileCostWeight) {
                keyRemainingWeight = 0L;
            }
            if (keyRemainingWeight != 0L) continue;
            KeyAssignment keyAssignment = new KeyAssignment(assignedSubtasks, subtaskWeights, closeFileCostWeight);
            assignmentMap.put(currentKey, keyAssignment);
            assignedSubtasks = Lists.newArrayList();
            subtaskWeights = Lists.newArrayList();
            currentKey = null;
        }
        return assignmentMap;
    }
}

