/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

class MapDataStatistics
implements DataStatistics {
    private final Map<SortKey, Long> keyFrequency;

    MapDataStatistics() {
        this.keyFrequency = Maps.newHashMap();
    }

    MapDataStatistics(Map<SortKey, Long> keyFrequency) {
        this.keyFrequency = keyFrequency;
    }

    @Override
    public StatisticsType type() {
        return StatisticsType.Map;
    }

    @Override
    public boolean isEmpty() {
        return this.keyFrequency.isEmpty();
    }

    @Override
    public void add(SortKey sortKey) {
        if (this.keyFrequency.containsKey(sortKey)) {
            this.keyFrequency.merge(sortKey, 1L, Long::sum);
        } else {
            SortKey copiedKey = sortKey.copy();
            this.keyFrequency.put(copiedKey, 1L);
        }
    }

    @Override
    public Object result() {
        return this.keyFrequency;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("map", this.keyFrequency).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapDataStatistics)) {
            return false;
        }
        MapDataStatistics other = (MapDataStatistics)o;
        return Objects.equal(this.keyFrequency, other.keyFrequency);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyFrequency});
    }
}

